
import java.util.*;
import java.io.*;

import jade.core.*;
import jade.core.behaviours.*;
import jade.lang.acl.*;
import jade.content.*;
import jade.content.lang.*;
import jade.content.lang.sl.*;
import jade.content.onto.basic.*;
import jade.domain.*;
import jade.domain.mobility.*;
import jade.domain.JADEAgentManagement.*;


public class RelayRaceAgent extends Agent {
	// ----------------------------------------

	//private AID controller;
	private String destination;

	private Map locations = new HashMap();

	protected boolean atHome;

	protected int team;
	protected int agentNum;
	protected int numContainers;
	protected int nextAgentNum;
	protected int totalNumLaps;
	protected int currentLap;

	protected int currentContainer;

	protected AID controller;

	protected void setup() {
		// ------------------------

		atHome = false;
		String[] team_agent_num_str = getLocalName().split("[\\D]+");
		team = Integer.parseInt(team_agent_num_str[1]);
		// Retrieve arguments passed during this agent creation
		Object[] args = getArguments();
		destination = (String)args[0];
		controller = (AID) args[1];
		totalNumLaps = (Integer)(args[2]);

		init();
		agentNum = Integer.parseInt(team_agent_num_str[2]);
		nextAgentNum = (agentNum + 1) % numContainers;

		// Program the main behaviour of this agent
		addBehaviour(new GoHomeBehaviour(this));
		addBehaviour(new ReceiveBaton(this));
	}

	void init() {
		// -------------

		// Register language and ontology
		getContentManager().registerLanguage(new SLCodec());
		getContentManager().registerOntology(MobilityOntology.getInstance());

		// Get available locations with AMS
		try
		{
			// Get available locations with AMS
			sendRequest(new Action(getAMS(), new QueryPlatformLocationsAction()));
			MessageTemplate mt = MessageTemplate.and(
					MessageTemplate.MatchSender(getAMS()),
					MessageTemplate.MatchPerformative(ACLMessage.INFORM));
			ACLMessage resp = blockingReceive(mt);
			ContentElement ce = getContentManager().extractContent(resp);
			Result result = (Result) ce;
			jade.util.leap.Iterator it = result.getItems().iterator();
			while (it.hasNext()) {
				Location loc = (Location)it.next();
				locations.put(loc.getName(), loc);
			}
			numContainers = locations.size() ;
		}
		catch(Exception ex) {ex.printStackTrace(); }
	}

	void sendRequest(Action action) {
		// ---------------------------------

		ACLMessage request = new ACLMessage(ACLMessage.REQUEST);
		request.setLanguage(new SLCodec().getName());
		request.setOntology(MobilityOntology.getInstance().getName());
		try {
			getContentManager().fillContent(request, action);
			request.addReceiver(action.getActor());
			send(request);
		}
		catch (Exception ex) { ex.printStackTrace(); }
	}

	protected void beforeMove() {
		// -----------------------------
	}

	protected void afterMove() {
		// ----------------------------
		currentContainer = (currentContainer % numContainers) + 1;

		//init(); /* Should not need to do this every time, I think... */
		/* Need to send a message to the next agent to move. */
		if(atHome == true) {
			currentLap++;
			checkFinished();
			ACLMessage msg = new ACLMessage(ACLMessage.REQUEST);
			msg.setContent("baton");
			msg.addReceiver( new AID("Team"+team+"Agent"+nextAgentNum, AID.ISLOCALNAME) );
			System.out.println(getLocalName() + "Sending message to Team"+team+"Agent"+nextAgentNum);
			send(msg);
		} else {
			currentLap = 0;
		}
		atHome = true;

	}

	protected void beforeClone() {
		// -----------------------------

	}

	protected void afterClone() {
		// ----------------------------

		init();
	}

	protected void checkFinished() {
		System.out.println(getLocalName() + "Check Finish: Lap: " + currentLap);
		if( 
				(currentLap >= totalNumLaps) &&
				(currentContainer == 1)
			) {
			ACLMessage msg = new ACLMessage(ACLMessage.INFORM);
			msg.setContent("RACE COMPLETE");
			msg.addReceiver(controller);
			send(msg);
			/* Relay a delete message down the chain */
			msg = new ACLMessage(ACLMessage.REQUEST);
			msg.setContent("delete");
			msg.addReceiver(new AID("Team"+team+"Agent"+nextAgentNum, AID.ISLOCALNAME));
			send(msg);
			doDelete();
		} /*else if (
				(currentLap >= totalNumLaps) &&
				(currentContainer == numContainers) 
				)
		{
			doDelete();
		} */
	}

	/*
	 * Receive the baton from previous agent. Once it is received, move to the
	 * next agency in the list.
	 */
	class ReceiveBaton extends CyclicBehaviour {

		// Call parent constructor
		ReceiveBaton(Agent a) { super(a); }

		public void action() {
			ACLMessage msg = receive();

			if (msg == null) { block(); return; }

			if (msg.getPerformative() == ACLMessage.REQUEST) {
				try {
					if (msg.getContent().compareTo("baton") == 0) {
						// Travel to next destination
						System.out.println(getLocalName() + " Received Baton.");
						doMove((Location)locations.get("Container-" + ((currentContainer%numContainers)+1)));
					}
					else if (msg.getContent().compareTo("delete") == 0) {
						/* Relay the message if we are not at the end */
						if (currentContainer != numContainers) {
							msg = new ACLMessage(ACLMessage.REQUEST);
							msg.setContent("delete");
							msg.addReceiver(new AID("Team"+team+"Agent"+nextAgentNum, AID.ISLOCALNAME));
							send(msg);
						}
						doDelete();
					}
				}
				catch (Exception ex) {ex.printStackTrace(); }
			}
			else {
				System.out.println("Unexpected message");
			}
		}
	}

	class GoHomeBehaviour extends SimpleBehaviour{
		GoHomeBehaviour(Agent a) {super(a);}

		public void action() {
			try {
				String[] splstring = destination.split("[\\D]+");
				currentContainer = Integer.parseInt(splstring[1]);
				doMove((Location)locations.get(destination));
			} catch (Exception ex) {ex.printStackTrace();}
		}

		public boolean done() {
			return atHome;
		}
	}
} // class MobileAgent
