import java.util.*;

import jade.*;
import jade.core.*;
import jade.core.behaviours.*;
import jade.content.lang.sl.*;
import jade.domain.mobility.*;
import jade.content.onto.basic.*;
import jade.domain.JADEAgentManagement.*;
import jade.lang.acl.*;
import jade.content.*;
import jade.wrapper.*;


public class RelayControlAgent extends Agent {
	private jade.wrapper.AgentContainer home;
	private jade.wrapper.AgentContainer[] container = null;
	private Map locations = new HashMap();
	private Vector agents = new Vector();
	private int agentCnt = 0;
	private int command;
	private int numTeams = 100;
	private int numLaps = 5;
	private int teamsCompleted = 0;
	long startTime;
	long endTime;

	// Get a JADE Runtime instance
	jade.core.Runtime runtime = jade.core.Runtime.instance();

	protected void setup() {
		System.out.println("Control Agent Startup.");
		/* We need to: 1: create a bunch of agents on different containers. Each agent we create,
			 we will notify them the following info.
			 - Their home container: So that they may migrate to their home agency before the test starts.
			 We do not need to tell them their agent/team numbers because they can figure that information
			 out from their name. 
			 We also do not need to inform the agent about the number of containers because the 
			 agent will get a list of all known locations and infer the number of containers. 
		 */


		// Register language and ontology
		getContentManager().registerLanguage(new SLCodec());
		getContentManager().registerOntology(MobilityOntology.getInstance());

		try
		{
			//home = runtime.createAgentContainer(new ProfileImpl());
			home = getContainerController();
			// Get available locations with AMS
			sendRequest(new Action(getAMS(), new QueryPlatformLocationsAction()));
			//Receive response from AMS
			MessageTemplate mt = MessageTemplate.and(
					MessageTemplate.MatchSender(getAMS()),
					MessageTemplate.MatchPerformative(ACLMessage.INFORM));
			ACLMessage resp = blockingReceive(mt);
			ContentElement ce = getContentManager().extractContent(resp);
			Result result = (Result) ce;
			jade.util.leap.Iterator it = result.getItems().iterator();
			while (it.hasNext()) {
				Location loc = (Location)it.next();
				try {
					System.out.println("Location: " + loc.getName() );
					locations.put(loc.getName(), loc);
				} catch (Exception ex) {ex.printStackTrace();}
			}
		}
		catch (Exception e) { e.printStackTrace(); }

		/* Create the agents. One runner per container. Do not count the main container as one
			 of the containers. */
		jade.wrapper.AgentController a = null;
		try 
		{
			for(int j = 0; j < numTeams; j++) {
				for(int i = 1; locations.containsKey("Container-" + i); i++) {
					Object[] args = new Object[3];
					args[0] = new String("Container-" + i);
					args[1] = getAID();
					args[2] = new Integer(numLaps);
					String name = "Team" + (j+1) + "Agent" + i;
					a = home.createNewAgent(name, RelayRaceAgent.class.getName(), args);
					agents.add(a);
					a.start();
				}
			}
			doWait(2000);
			/* Now send trigger agents */
			startTime = System.currentTimeMillis();
			for(int j = 0; j < numTeams; j++) {
				Object[] args = new Object[3];
				args[0] = new String("Container-1");
				args[1] = getAID();
				args[2] = new Integer(numLaps);
				String name = "Team" + (j+1) + "Agent0";
				a = home.createNewAgent(name, TriggerAgent.class.getName(), args);
				agents.add(a);
				a.start();
			}
		}
		catch (Exception ex) {
			System.out.println("Problem creating new agent.");
			ex.printStackTrace();
		}

		addBehaviour(new ReceiveCommands(this));
	}

	void sendRequest(Action action) {
		// ---------------------------------

		ACLMessage request = new ACLMessage(ACLMessage.REQUEST);
		request.setLanguage(new SLCodec().getName());
		request.setOntology(MobilityOntology.getInstance().getName());
		try {
			getContentManager().fillContent(request, action);
			request.addReceiver(action.getActor());
			send(request);
		}
		catch (Exception ex) { ex.printStackTrace(); }
	}

	class ReceiveCommands extends CyclicBehaviour{
		ReceiveCommands(Agent a) { super(a); }
		public void action()
		{
			ACLMessage msg = receive();
			if (msg == null) {block(); return;}
			if (msg.getPerformative() == ACLMessage.INFORM) {
				try
				{
					if (msg.getContent().compareTo("RACE COMPLETE") == 0) {
						teamsCompleted++;
					}
				}
				catch (Exception ex) {ex.printStackTrace();}
				if (teamsCompleted >= numTeams) {
					endTime = System.currentTimeMillis();
					System.out.println("RACE TIME: " + (endTime - startTime) + " ms");
				}
			} else {
				System.out.println("Controller received unknown message.");
			}
		}
	}
}
