Public Class Form1
    Dim Agency As LibMC.MCAgency = New LibMC.MCAgency
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Label2.Text = Agency.State.ToString
    End Sub

    Private Sub Form1_FormClosing(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        If ((Agency.State = LibMC.MCAgency.MCAgencyState.Running) Or (Agency.State = LibMC.MCAgency.MCAgencyState.Halted)) Then
            Agency.End()
        End If
    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Dim temp As Integer
        If (Agency.State = LibMC.MCAgency.MCAgencyState.Initialized) Then
            Agency.Port = NumericUpDown1.Value
            temp = Agency.SetThreadOff(LibMC.MCAgency.MC_ThreadIndex_e.MC_THREAD_CP)
            If (temp <> 0) Then
                Console.WriteLine("SetThreadOff: " + temp.ToString())
            End If
            temp = Agency.Initialize()
            If (temp <> 0) Then
                Console.WriteLine("Initialize: " + temp.ToString())
            Else
                Console.WriteLine("Started agency.")
                Button1.Text = "Halt Agency"
            End If
        Else
            If (Agency.State = LibMC.MCAgency.MCAgencyState.Running) Then
                temp = Agency.HaltAgency()
                If (temp <> 0) Then
                    Console.WriteLine("Error halting agency: " + temp.ToString())
                Else
                    Button1.Text = "Resume Agency"
                End If
            Else
                If (Agency.State = LibMC.MCAgency.MCAgencyState.Halted) Then
                    temp = Agency.ResumeAgency()
                    If (temp <> 0) Then
                        Console.WriteLine("Error resuming agency: " + temp.ToString())
                    Else
                        Button1.Text = "Halt Agency"
                    End If
                Else
                    Console.WriteLine("Error: Agency is in an unknown state: " + Agency.State.ToString())
                End If
            End If
        End If

        label2.Text = Agency.State.ToString()

    End Sub
End Class
