using System;
using System.Collections.Generic;
using System.Text;
using LibMC;
using System.Threading;

/** \file /LibMCMiscTest/Program.cs
 * Program for testing miscellaneous functions in LibMC.NET.
 */

/**
 * \brief      Namespace for the LibMCMiscTest miscellaneous functions
 *             test program.
 * 
 * This program demonstrates how to start an agency, load agents, and 
 * miscellaneous functions.
 */
namespace LibMCMiscTest
{
    /**
     * \brief   Main program class to start the example.
     */
    class Program
    {
        public static MCAgency Agency = new MCAgency();
        public static int localport = 5050;
        public static int remoteport = 5051;

        static void Main(string[] args)
        {
            int temp;

            Console.WriteLine("Starting Mobile-C.\n");

            Agency.Port = localport;
            temp = Agency.Initialize();
            if (temp != 0)
                Console.WriteLine("Initialize: " + temp.ToString() + "\n");
            Agency.ResetSignal();

            Console.WriteLine("Waiting for an agent to arrive.");

            MCAgent agent;
            agent = Agency.WaitRetrieveAgent();

            String xml = agent.GetAgentXMLString();
            Console.Write("Agent XML String:");
            Console.WriteLine(xml);

            String str = agent.RetrieveAgentCode();
            Console.Write("Agent Code:");
            Console.WriteLine(str);
            Agency.ResetSignal();

            Console.WriteLine("Type \"quit\" to exit...");

            while (true) ;
        }
    }
}
