#include <stdio.h>
#include <stdlib.h>
#include <libmc.h>

int main(int argc, char *argv[]) 
{
  MCAgency_t agency;
  MCAgencyOptions_t options;

  MC_InitializeAgencyOptions(&options);
  MC_SetThreadOff(&options, MC_THREAD_CP);
  agency = MC_Initialize(5051, &options);

  printf("Mobile-C Started\n");
  /* Note: The third argument of the following function may also be a
     valid IP address in the form of a string. i.e. 192.168.0.1 */
  MC_SendAgentMigrationMessageFile(agency,
      "message_box.xml",
      "localhost",
      5050);
  MC_End(agency);
  return 0;
}
