#include <libmc.h>
#include <stdio.h>
int main(int argc, char *argv[])
{
    MCAgency_t agency;
    MCAgencyOptions_t options;
    int i;
    MC_InitializeAgencyOptions(&options);
    /* We want _all_ the threads on: EXCEPT, the command prompt thread */
    for (i = 0; i < MC_THREAD_ALL; i++) {
        MC_SetThreadOn(&options, i);
    }
 /*   MC_SetThreadOff(&options, MC_THREAD_CP);  */

    agency = MC_Initialize(
            5051,
            &options);

    /* Set up a condition variable */
    MC_SyncInit(agency, 42);
    
    /* Wait on the condition variable in an infinite loop. Every time the 
     * condition variable is signalled, send our 'data retrieval' agent. */
    while(1) {
      MC_CondWait(agency, 42);
      MC_SendAgentMigrationMessageFile(
          agency,
          "retrieval_agent.xml",
          "localhost",
          5052
          );
      MC_CondReset(agency, 42);
    }

    /* Wait forever... */
    MC_MainLoop(agency);
    return 0;
}

