#include <libmc.h>
#include <stdio.h>
#ifdef _WIN32
#include <windows.h>
#else
#include <unistd.h>
#endif
int main(int argc, char *argv[])
{
    MCAgency_t agency1;
    MCAgency_t agency2;
    MCAgencyOptions_t options;
    int i;

    MCAgent_t agent;
    MCAgent_t agent_copy;

    MC_InitializeAgencyOptions(&options);
    /* We want _all_ the threads on: EXCEPT, the command prompt thread */
    for (i = 0; i < MC_THREAD_ALL; i++) {
        MC_SetThreadOn(&options, i);
    }
    MC_SetThreadOff(&options, MC_THREAD_CP);  

    agency1 = MC_Initialize(
        5051,
        &options);
    agency2 = MC_Initialize(
        5052,
        &options);

    while(1) {
      agent = MC_WaitRetrieveAgent(agency1);
      MC_CopyAgent(&agent_copy, agent);
      MC_SetAgentStatus(agent_copy, MC_WAIT_CH);
      MC_AddAgent(agency2, agent_copy);
      MC_ResetSignal(agency1);
    }

    return 0;
}

