#include <stdio.h>
#include <libmc.h>
#ifdef _WIN32
#include <windows.h>
#endif
#define WAIT_TIME 2
int main(int argc, char *argv[]) 
{
    MCAgency_t agency;
    MCAgencyOptions_t options;

    MC_InitializeAgencyOptions(&options);
    MC_SetThreadOff(&options, MC_THREAD_CP);
    agency = MC_Initialize(5050, &options);

    printf("MobileC Started\n");
    printf("Sending sleep agent...\n");
    /* Note: The third argument of the following function may also be a
       valid IP address in the form of a string. i.e. 192.168.0.1 */
    MC_SendAgentMigrationMessageFile(
        agency,
        "sleep.xml",
        "localhost",
        5051);
    printf("Sleeping for %d seconds.\n", WAIT_TIME);
#ifndef _WIN32
    sleep(WAIT_TIME);
#else
    Sleep(WAIT_TIME * 1000);
#endif
    printf("Sending wake-up agent...\n");
    /* Note: The third argument of the following function may also be a
       valid IP address in the form of a string. i.e. 192.168.0.1 */
    MC_SendAgentMigrationMessageFile(
        agency,
        "wake.xml",
        "localhost",
        5051);
    MC_End(agency);
    return 0;
}
