/*[
 * Copyright (c) 2007 Integration Engineering Laboratory
                      University of California, Davis
 *
 * Permission to use, copy, and distribute this software and its
 * documentation for any purpose with or without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 *
 * Permission to modify the software is granted, but not the right to
 * distribute the complete modified source code.  Modifications are to
 * be distributed as patches to the released version.  Permission to
 * distribute binaries produced by compiling modified sources is granted,
 * provided you
 *   1. distribute the corresponding source modifications from the
 *    released version in the form of a patch file along with the binaries,
 *   2. add special version identification to distinguish your version
 *    in addition to the base release version number,
 *   3. provide your name and address as the primary contact for the
 *    support of your modified version, and
 *   4. retain our contact information in regard to use of the base
 *    software.
 * Permission to distribute the released version of the source code along
 * with corresponding source modifications in the form of a patch file is
 * granted with same provisions 2 through 4 for binary distributions.
 *
 * This software is provided "as is" without express or implied warranty
 * to the extent permitted by applicable law.
]*/

#ifndef _FIPA_ACL_MESSAGE_H_
#define _FIPA_ACL_MESSAGE_H_

enum fipa_performative_e
{
  FIPA_ERROR=-1,
  FIPA_ZERO,
  FIPA_ACCEPT_PROPOSAL,
  FIPA_AGREE,
  FIPA_CANCEL,
  FIPA_CALL_FOR_PROPOSAL,
  FIPA_CONFIRM,
  FIPA_DISCONFIRM,
  FIPA_FAILURE,
  FIPA_INFORM,
  FIPA_INFORM_IF,
  FIPA_INFORM_REF,
  FIPA_NOT_UNDERSTOOD,
  FIPA_PROPOGATE,
  FIPA_PROPOSE,
  FIPA_PROXY,
  FIPA_QUERY_IF,
  FIPA_QUERY_REF,
  FIPA_REFUSE,
  FIPA_REJECT_PROPOSAL,
  FIPA_REQUEST,
  FIPA_REQUEST_WHEN,
  FIPA_REQUEST_WHENEVER,
  FIPA_SUBSCRIBE
};

typedef enum fipa_expression_type_e
{
  FIPA_EXPR_ZERO,
  FIPA_EXPR_WORD,
  FIPA_EXPR_STRING,
  FIPA_EXPR_NUMBER,
  FIPA_EXPR_DATETIME,
  FIPA_EXPR_EXPRESSION
} fipa_expression_type_t; 

typedef struct fipa_acl_message_s
{
  enum fipa_performative_e performative;

  struct fipa_agent_identifier_s* sender;

  struct fipa_agent_identifier_set_s* receiver;
  int receiver_num;

  struct fipa_agent_identifier_set_s* reply_to;

  /*struct fipa_content_s* content; */
  struct fipa_string_s* content; /* We will write the parser for this later */

  struct fipa_expression_s* language;

  struct fipa_expression_s* encoding;
  
  struct fipa_expression_s* ontology;

  struct fipa_word_s* protocol;

  struct fipa_expression_s* conversation_id;

  struct fipa_expression_s* reply_with;

  struct fipa_expression_s* in_reply_to;

  struct fipa_DateTime_s* reply_by;
} fipa_acl_message_t;
typedef fipa_acl_message_t* fipa_acl_message_p;

typedef struct fipa_message_string_s
{
  char* message;
  char* parse;    /* This pointer points to some part of "message" */
} fipa_message_string_t;
typedef fipa_message_string_t* fipa_message_string_p;

typedef struct fipa_agent_identifier_s
{
  char* name;
  struct fipa_url_sequence_s* addresses;
  struct fipa_agent_identifier_s** resolvers;
} fipa_agent_identifier_t;
typedef fipa_agent_identifier_t* fipa_agent_identifier_p;

typedef struct fipa_agent_identifier_set_s
{
  int num;
  struct fipa_agent_identifier_s** fipa_agent_identifiers;
} fipa_agent_identifier_set_t;
typedef fipa_agent_identifier_set_t* fipa_agent_identifier_set_p;

typedef struct fipa_expression_s
{
  enum fipa_expression_type_e type;
  union content_u
  {
    struct fipa_word_s* word;
    struct fipa_string_s* string;
    struct fipa_Number_s* number;
    struct fipa_DateTime_s* datetime;
    struct fipa_expression_s** expression;
  } content;
} fipa_expression_t;
typedef fipa_expression_t* fipa_expression_p;

typedef struct fipa_word_s
{
  char* content;
} fipa_word_t;
typedef fipa_word_t* fipa_word_p;

typedef struct fipa_string_s
{
  char* content;
} fipa_string_t;
typedef fipa_string_t* fipa_string_p;

typedef struct fipa_DateTime_s
{
  int year;
  int month;
  int day;
  int hour;
  int minute;
  int second;
  int millisecond;
  char sign; /* May be '+', '-', or '\0' */
  int is_utc; /* May be 1 (yes) or 0 (no) */
} fipa_DateTime_t;
typedef fipa_DateTime_t* fipa_DateTime_p;

typedef struct fipa_url_s
{
  char *str;
} fipa_url_t;
typedef fipa_url_t* fipa_url_p;

typedef struct fipa_url_sequence_s
{
  int num;
  struct fipa_url_s** urls;
} fipa_url_sequence_t;
typedef fipa_url_sequence_t* fipa_url_sequence_p;


int fipa_acl_Parse(struct fipa_acl_message_s* acl, fipa_message_string_p message);
int fipa_message_parameter_Parse(struct fipa_acl_message_s* acl, fipa_message_string_p message);
int fipa_message_type_Parse(
    enum fipa_performative_e* performative, 
    fipa_message_string_p message
    );
int fipa_GetAtom(
    fipa_message_string_p message,
    char expected_atom
    );
int fipa_word_Parse(fipa_word_t** word, fipa_message_string_p message);
int fipa_word_Destroy(fipa_word_t* word);
int fipa_CheckNextToken(const fipa_message_string_p message, const char* token);
int fipa_expression_Parse(fipa_expression_t** expression, fipa_message_string_p message);
int fipa_GetNextWord(char** word, const fipa_message_string_p message);
int fipa_datetime_Parse(fipa_DateTime_p* datetime, fipa_message_string_p message);
int fipa_string_Parse( fipa_string_p* fipa_string, fipa_message_string_p message);
int fipa_agent_identifier_Parse(fipa_agent_identifier_p* aid, fipa_message_string_p message);
int fipa_agent_identifier_set_Parse(fipa_agent_identifier_set_p* agent_ids, fipa_message_string_p message);
int fipa_url_sequence_Parse(fipa_url_sequence_p* urls, fipa_message_string_p message);
#endif
