/*[
 * Copyright (c) 2007 Integration Engineering Laboratory
                      University of California, Davis
 *
 * Permission to use, copy, and distribute this software and its
 * documentation for any purpose with or without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 *
 * Permission to modify the software is granted, but not the right to
 * distribute the complete modified source code.  Modifications are to
 * be distributed as patches to the released version.  Permission to
 * distribute binaries produced by compiling modified sources is granted,
 * provided you
 *   1. distribute the corresponding source modifications from the
 *    released version in the form of a patch file along with the binaries,
 *   2. add special version identification to distinguish your version
 *    in addition to the base release version number,
 *   3. provide your name and address as the primary contact for the
 *    support of your modified version, and
 *   4. retain our contact information in regard to use of the base
 *    software.
 * Permission to distribute the released version of the source code along
 * with corresponding source modifications in the form of a patch file is
 * granted with same provisions 2 through 4 for binary distributions.
 *
 * This software is provided "as is" without express or implied warranty
 * to the extent permitted by applicable law.
]*/

#ifndef _AP_MODULES_H_
#define _AP_MODULES_H_
#include "ap_queue_template.h"
#include "../mc_list/list.h"
struct mc_platform_s;
/* Connection Queue */
#include "connection.h"
AP_QUEUE_DECL_TEMPLATE(
    connection_queue, /* name */
    connection /* node_type */
    )

AP_QUEUE_GENERIC_DECL_TEMPLATE(
    connection_queue,
    Search,
    connection_t*,
    int
    )

AP_QUEUE_GENERIC_DECL_TEMPLATE(
    connection_queue,
    Remove,
    int,
    int
    )

int 
connection_queue_Print(connection_queue_p clist);

/* Message Queue */
#include"message.h"
AP_QUEUE_DECL_TEMPLATE(
    message_queue,
    message
    )

int 
message_queue_Print(message_queue_p queue);

/* Agent Queue */
#include"agent.h"
AP_QUEUE_DECL_TEMPLATE(
    agent_queue,
    agent
    )

AP_QUEUE_GENERIC_DECL_TEMPLATE(
    agent_queue,
    Search,
    agent_t*,
    int
    )

AP_QUEUE_GENERIC_DECL_TEMPLATE(
    agent_queue,
    SearchName,
    agent_t*,
    char*
    )

AP_QUEUE_GENERIC_DECL_TEMPLATE(
    agent_queue,
    Remove,
    int,
    int
    )

AP_QUEUE_GENERIC_DECL_TEMPLATE(
    agent_queue,
    RemoveName,
    int,
    char*
    )

int
agent_queue_Print(agent_queue_p queue);
#endif
