/*[
 * Copyright (c) 2007 Integration Engineering Laboratory
                      University of California, Davis
 *
 * Permission to use, copy, and distribute this software and its
 * documentation for any purpose with or without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 *
 * Permission to modify the software is granted, but not the right to
 * distribute the complete modified source code.  Modifications are to
 * be distributed as patches to the released version.  Permission to
 * distribute binaries produced by compiling modified sources is granted,
 * provided you
 *   1. distribute the corresponding source modifications from the
 *    released version in the form of a patch file along with the binaries,
 *   2. add special version identification to distinguish your version
 *    in addition to the base release version number,
 *   3. provide your name and address as the primary contact for the
 *    support of your modified version, and
 *   4. retain our contact information in regard to use of the base
 *    software.
 * Permission to distribute the released version of the source code along
 * with corresponding source modifications in the form of a patch file is
 * granted with same provisions 2 through 4 for binary distributions.
 *
 * This software is provided "as is" without express or implied warranty
 * to the extent permitted by applicable law.
]*/

#include "include/ap_queue_template.h"
#include "include/data_structures.h"
/* Connection Queue */
AP_QUEUE_STD_DEFN_TEMPLATE(connection_queue, connection)

AP_QUEUE_SEARCH_TEMPLATE(
    connection_queue,
    Search,
    connection,
    int,
    (node->connect_id == key)
    )

AP_QUEUE_REMOVE_TEMPLATE(
    connection_queue,
    Remove,
    connection,
    int,
    (node->connect_id == key)
    )

int 
connection_queue_Print(connection_queue_p queue)
{
  int i;
  connection_p node;
  MUTEX_LOCK(queue->lock);
  for(i = 0; i < queue->size; i++) {
    node = (connection_p)ListSearch(queue->list, i);
    if (node != NULL) {
      printf("Connection id %d:\n\tremote:%s\n",
          node->connect_id,
          node->remote_hostname
          );
    }
  }
  MUTEX_UNLOCK(queue->lock);
  return i;
}
        
/* Message Queue */
AP_QUEUE_STD_DEFN_TEMPLATE(
    message_queue,
    message
    )

AP_QUEUE_SEARCH_TEMPLATE(
    message_queue,
    Search,
    message,
    int,
    (node->message_id == key)
    )

AP_QUEUE_REMOVE_TEMPLATE(
    message_queue,
    Remove,
    message,
    int,
    (node->message_id == key)
    )

int
message_queue_Print(message_queue_p queue)
{
  int i;
  message_p node;
  MUTEX_LOCK(queue->lock);
  for(i = 0; i < queue->size; i++) {
    node = (message_p)ListSearch(queue->list, i);
    if (node != NULL) {
      printf("Connection id %d:\n\tfrom:%s\n\tto:%s\n",
          node->message_id,
          node->from_address,
          node->to_address
          );
    }
  }
  MUTEX_UNLOCK(queue->lock);
  return i;
}


/* Agent Queue */
AP_QUEUE_STD_DEFN_TEMPLATE(
    agent_queue,
    agent
    )
AP_QUEUE_SEARCH_TEMPLATE(
    agent_queue,
    Search,
    agent,
    int,
    (node->id == key)
    )
AP_QUEUE_SEARCH_TEMPLATE(
    agent_queue,
    SearchName,
    agent,
    char*,
    (!strcmp(node->name, key))
    )
AP_QUEUE_REMOVE_TEMPLATE(
    agent_queue,
    Remove,
    agent,
    int,
    (node->id == key)
    )
AP_QUEUE_REMOVE_TEMPLATE(
    agent_queue,
    RemoveName,
    agent,
    char*,
    (!strcmp(node->name, key))
    )

int
agent_queue_Print(agent_queue_p queue)
{
  int i;
  agent_p node;
  MUTEX_LOCK(queue->lock);
  for(i = 0; i < queue->size; i++) {
    node = (agent_p)ListSearch(queue->list, i);
    if (node != NULL) {
      printf("agent id %d:\n\tname:%s\n",
          (int)node->id,
          node->name
          );
    }
  }
  MUTEX_UNLOCK(queue->lock);
  return i;
}
