/*[
 * Copyright (c) 2007 Integration Engineering Laboratory
                      University of California, Davis
 *
 * Permission to use, copy, and distribute this software and its
 * documentation for any purpose with or without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 *
 * Permission to modify the software is granted, but not the right to
 * distribute the complete modified source code.  Modifications are to
 * be distributed as patches to the released version.  Permission to
 * distribute binaries produced by compiling modified sources is granted,
 * provided you
 *   1. distribute the corresponding source modifications from the
 *    released version in the form of a patch file along with the binaries,
 *   2. add special version identification to distinguish your version
 *    in addition to the base release version number,
 *   3. provide your name and address as the primary contact for the
 *    support of your modified version, and
 *   4. retain our contact information in regard to use of the base
 *    software.
 * Permission to distribute the released version of the source code along
 * with corresponding source modifications in the form of a patch file is
 * granted with same provisions 2 through 4 for binary distributions.
 *
 * This software is provided "as is" without express or implied warranty
 * to the extent permitted by applicable law.
]*/

#include "include/agent_return_data.h"
#include "include/agent.h"

agent_return_data_p
agent_return_data_New(void)
{
  agent_return_data_p agent_return_data;
  agent_return_data = (agent_return_data_p)malloc(sizeof(agent_return_data_t));
  CHECK_NULL(agent_return_data, exit(0););
  agent_return_data->data_type = 0;
  agent_return_data->array_dim = 0;
  agent_return_data->array_extent = NULL;
  agent_return_data->return_data = NULL;
  return agent_return_data;
}

agent_return_data_p 
agent_return_data_InitializeFromAgent(agent_p agent)
{
    int i;
    int size;
    int data_type_size;
    int progress;
    agent_return_data_t *agent_return;
    agent_return = (agent_return_data_t*)malloc(sizeof(agent_return_data_t));
    /* Get the array data type */
    agent_return->data_type = Ch_DataType(
            agent->agent_interp,
            agent->datastate->tasks[agent->datastate->task_progress]
            ->var_name );
    /* Get the array dimension */
    agent_return->array_dim = Ch_ArrayDim(
            agent->agent_interp,
            agent->datastate->tasks[agent->datastate->task_progress]
            ->var_name );
    /* Get the array extents */
    agent_return->array_extent = (int*)malloc(
            sizeof(int) * agent_return->array_dim );
    for (i=0; i<agent_return->array_dim; i++) {
        agent_return->array_extent[i] = 
            Ch_ArrayExtent(
                    agent->agent_interp,
                    agent->datastate
                    ->tasks[agent->datastate->task_progress]
                    ->var_name,
                    i );
    }
    /* Finally, allocate and point returnData to the right place. */
    size = 1;
    for (i=0; i < agent_return->array_dim; i++) {
        size *= agent_return->array_extent[i];
    }

    /* Now get the data type size */
    CH_DATATYPE_SIZE(agent_return->data_type, data_type_size);

    agent_return->return_data = (void*)malloc(size * data_type_size);
    CHECK_NULL(agent_return->return_data, exit(0));
    /* Copy the data over from the agent */
    /* For now, only support statically allocated global vars. */
    progress = agent->datastate->task_progress;
    i = 0;

    if (agent_return->array_dim == 0) {
        memcpy(
                agent_return->return_data,
                (void*)Ch_GlobalSymbolAddrByName(
                    agent->agent_interp,
                    agent->datastate->tasks[progress]->var_name),
                size*data_type_size
              );

    } else {
        memcpy(
                agent_return->return_data,
                (void*)Ch_GlobalSymbolAddrByName(
                    agent->agent_interp,
                    agent->datastate->tasks[progress]->var_name),
                size*data_type_size
              );
    }

    /* getAgentReturnArrays(
       agent_return->returnData,
       Ch_SymbolAddrByName(
       agent->agent_interp,
       agent->datastate->tasks[progress]->var_name),
       &i,
       agent_return->array_dim,
       agent_return->array_extent,
       agent_return->data_type ); */

    return agent_return;
}

int
agent_return_data_Destroy(agent_return_data_p agent_return_data)
{
  if (agent_return_data == NULL) {
    return MC_SUCCESS;
  }
  if (agent_return_data->array_extent != NULL) {
    free(agent_return_data->array_extent);
  }
  if (agent_return_data->return_data != NULL) {
    free(agent_return_data->return_data);
  }
  free(agent_return_data);
  return MC_SUCCESS;
}

