/*[
 * Copyright (c) 2007 Integration Engineering Laboratory
                      University of California, Davis
 *
 * Permission to use, copy, and distribute this software and its
 * documentation for any purpose with or without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 *
 * Permission to modify the software is granted, but not the right to
 * distribute the complete modified source code.  Modifications are to
 * be distributed as patches to the released version.  Permission to
 * distribute binaries produced by compiling modified sources is granted,
 * provided you
 *   1. distribute the corresponding source modifications from the
 *    released version in the form of a patch file along with the binaries,
 *   2. add special version identification to distinguish your version
 *    in addition to the base release version number,
 *   3. provide your name and address as the primary contact for the
 *    support of your modified version, and
 *   4. retain our contact information in regard to use of the base
 *    software.
 * Permission to distribute the released version of the source code along
 * with corresponding source modifications in the form of a patch file is
 * granted with same provisions 2 through 4 for binary distributions.
 *
 * This software is provided "as is" without express or implied warranty
 * to the extent permitted by applicable law.
]*/

#ifndef _WIN32
#include <unistd.h>
#endif

#include <embedch.h>

#include "include/agent.h"
#include "include/mc_platform.h"
#include "include/message.h"
#include "include/agent_lib.h"
#include "include/agent_return_data.h"
#include "include/xml_parser.h"

  agent_p
agent_Copy(const agent_p agent)
{
  agent_p cp_agent;
  cp_agent = (agent_p)malloc(sizeof(agent_t));

  MUTEX_LOCK(agent->lock);
  /* id */
  cp_agent->id = agent->id;
  /* name */
  cp_agent->name = (char*)malloc
    (
     sizeof(char) * 
     (strlen(agent->name) + 1)
    );
  strcpy(cp_agent->name, agent->name);
  /* connect_id: Not Needed */
  /* arrival_time */
  cp_agent->arrival_time = agent->arrival_time;
  /*owner*/
  cp_agent->owner = (char*)malloc
    (
     sizeof(char) * 
     (strlen(agent->owner) + 1)
    );
  strcpy(cp_agent->owner, agent->owner);
  /*home*/
  cp_agent->home = (char*)malloc
    (
     sizeof(char) * 
     (strlen(agent->home) + 1)
    );
  strcpy(cp_agent->home, agent->home);
  /*home_port*/
  cp_agent->home_port = agent->home_port;
  /*datastate*/
  cp_agent->datastate = agent_datastate_Copy(agent->datastate);
  /* Agent is an orphan */
  cp_agent->orphan = 1;
  /*agent_type*/
  cp_agent->agent_type = agent->agent_type;
  /*agent_status*/
  cp_agent->agent_status = agent->agent_status;
  /*return_data*/
  cp_agent->return_data = agent->return_data;
  /*agent_interp*/
  cp_agent->agent_interp = NULL;
  /*agent_thread*/
  cp_agent->agent_thread = NULL;
  /*run_lock*/
  cp_agent->run_lock = (MUTEX_T*)malloc(sizeof(MUTEX_T));
  MUTEX_INIT(cp_agent->run_lock);
  /*agent_persistent*/
  cp_agent->agent_persistent = agent->agent_persistent;
  
  /*lock*/
  cp_agent->lock = (MUTEX_T*)malloc(sizeof(MUTEX_T));
  MUTEX_INIT(cp_agent->lock);

  return cp_agent;
}

  agent_p 
agent_Initialize(
    struct mc_platform_s *mc_platform,
    message_p message,
    int id)
{
  agent_p agent; 
  int err_code;

  /* malloc memory for the agent */
  agent = (MCAgent_t)malloc(sizeof(agent_t));
  memset(agent, 0, sizeof(agent_t));

  /* Set up general agent data access mutex */
  agent->lock = (MUTEX_T*)malloc(sizeof(MUTEX_T));
  MUTEX_INIT(agent->lock);

  /* Set up run_lock mutex */
  agent->run_lock = (MUTEX_T*)malloc(sizeof(MUTEX_T));
  MUTEX_INIT(agent->run_lock);

  /* set flags and variables for the agent */
  agent->id = id;
#ifndef _WIN32
  agent->arrival_time = time(NULL);
#else
  GetSystemTime( &(agent->arrival_time) );
#endif

  /* set flags */
  agent->orphan = 0;
  agent->agent_script_ready = 1;
  agent->agent_pipe_ready_to_read = 0;
  agent->agent_ready_to_send = 0;
  agent->agent_pipe_active = 0;

  /* set the agent thread to null until activated */
  agent->agent_thread = NULL;
  agent->agent_thread_id = 0;

  /* parse the xml */
  agent->datastate = agent_datastate_New();
  agent->datastate->xml_agent_root = message->xml_payload;
  agent->datastate->xml_root = message->xml_root;
  message->agent_xml_flag = 1;
  
  if (agent->datastate->xml_agent_root != NULL) {
    switch(message->message_type) {
      case MOBILE_AGENT:
        agent->agent_type = MC_REMOTE_AGENT;
        if( (err_code = agent_xml_parse(agent))) {
          fprintf(stderr, "error code %d. %s:%d\n",
              err_code, __FILE__, __LINE__ );
          agent_Destroy(agent);
          return NULL;
        }
        if (mc_platform->default_agentstatus != -1) {
          agent->agent_status = mc_platform->default_agentstatus;
        }
        break;
      case RETURN_MSG:
        agent->agent_type = MC_RETURN_AGENT;
        if( (err_code = agent_xml_parse(agent))) {
          fprintf(stderr, "error code %d. %s:%d\n",
              err_code, __FILE__, __LINE__ );
          agent_Destroy(agent);
          return NULL;
        }
        break;
      default:
        fprintf(stderr, "Invalid agent type: %d %s:%d\n",
            agent->agent_type, __FILE__, __LINE__ );
    }
  } else {
    mc_platform->err = MC_ERR_PARSE;
    /* Free up memory. */
    MUTEX_DESTROY(agent->lock);
    free(agent->lock);
    MUTEX_DESTROY(agent->run_lock);
    free(agent->run_lock);

    free(agent);
    return NULL;
  }

  /* In the future we will compare the current tasks server name to 
     the one on the server, presently this is not implemented */

  /* set the CH exectution flag */
  /* FIXME: This should be in the xml parser */
  /*if (agent->datastate->tasks[agent->datastate->task_progress]->init_agent_status != -1) {
    agent->agent_status = agent->datastate->tasks[agent->datastate->task_progress]->init_agent_status;
    } else {
    agent->agent_status = mc_platform->default_agentstatus;
    }
    */
  agent->agent_status = MC_WAIT_CH;

  agent->mc_platform = mc_platform;

  /* return */
  return agent;
}

  int
agent_Destroy(agent_p agent)
{
  if (agent == NULL) {
    return MC_SUCCESS;
  }
  MUTEX_LOCK(agent->lock);
  if (agent->name != NULL) {
    free(agent->name);
  }
  if (agent->owner != NULL) {
    free(agent->owner);
  }
  if (agent->home != NULL) {
    free(agent->home);
  }
  /* Terminate the agent datastate memory */
  MUTEX_DESTROY(agent->lock);
  if (agent->agent_status == MC_AGENT_NEUTRAL) {
    if ((agent->agent_interp) != NULL) {
      Ch_End(agent->agent_interp);
    }
  }
  free(agent->lock);
  agent_datastate_Destroy(agent->datastate);
  free(agent->agent_thread);
  free(agent->run_lock);
  /* deallocate the agent */
  free(agent);
  agent = NULL;
  return MC_SUCCESS;
}

  extern void 
agent_RunChScript(agent_p agent, mc_platform_p mc_platform)
{
#ifndef _WIN32
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  if(mc_platform->stack_size[MC_THREAD_AGENT] != -1) {
    pthread_attr_setstacksize
      (
       &attr, 
       mc_platform->stack_size[MC_THREAD_AGENT]
      );
  }
  pthread_attr_setdetachstate /* Automatically reclaim thread memory for this thread */
    (
     &attr,
     PTHREAD_CREATE_DETACHED
    );
#else
  int stack_size;
  if (mc_platform->stack_size[MC_THREAD_AGENT] < 1) {
	  stack_size = mc_platform->stack_size[MC_THREAD_AGENT]+1;
  } else {
	  stack_size = mc_platform->stack_size[MC_THREAD_AGENT];
  }
#endif
  if(agent->agent_thread == NULL) 
  {
    agent->agent_thread = (THREAD_T *)malloc(sizeof(THREAD_T));
  }

  agent->agent_status = MC_AGENT_ACTIVE;
  agent->mc_platform = mc_platform;

  THREAD_CREATE(agent->agent_thread,
      agent_RunChScriptThread,
      agent );

  return;
}

#ifndef _WIN32
  void* 
agent_RunChScriptThread(void * ChAgent)
#else
  DWORD WINAPI 
agent_RunChScriptThread(void* ChAgent)
#endif
{
#ifndef _WIN32
  int fd;
#endif
  MCAgent_t agent;
  mc_platform_p mc_platform;
  int n;
  FILE *TEMP_FILE;
  char *temp_store_file;
  char *ChShellArg[2];
  void *result;
  int progress;
  char *tmp_buf;

  /* set up the agent object */
  agent = (MCAgent_t)ChAgent;
  progress = agent->datastate->task_progress;
  mc_platform = agent->mc_platform;

  /* check to see if the agent is null */
  if(ChAgent == NULL)
  {
    printf("ERROR, AGENT NULL \n");
#ifndef _WIN32
    return NULL;
#else
    return 0;
#endif
  }
  /* We need to check for custom interp_options. If any
   * value is null, then we pass null on to Ch_Initialize. */
  if( ((MCAgent_t)ChAgent)->mc_platform->interp_options == NULL ) {

    if(Ch_Initialize(&(((MCAgent_t)ChAgent)->agent_interp), 
          NULL))
    {
      printf("CH INIT ERROR \n");
      exit(EXIT_FAILURE);
    }
  } else {
    if(Ch_Initialize(&(((MCAgent_t)ChAgent)->agent_interp), 
          ((MCAgent_t)ChAgent)->mc_platform->interp_options))
    {
      printf("CH INIT ERROR \n");
      exit(EXIT_FAILURE);
    }
  }

  /* Declare special variables for holding the agent id and name */
  tmp_buf = malloc(sizeof(char) * 200);
  tmp_buf[0] = '\0';
  sprintf(tmp_buf, "int mc_agent_id=%d;", (int)agent->id);
  Ch_DeclareVar(
      agent->agent_interp,
      tmp_buf
      );

  tmp_buf[0] = '\0';
  sprintf(tmp_buf,
      "char mc_agent_name[]=\"%s\";",
      agent->name
      );
  Ch_DeclareVar(
      agent->agent_interp,
      tmp_buf
      );

  tmp_buf[0] = '\0';
  sprintf(tmp_buf, "void* mc_current_agent = (void*)%d;", (int)agent);
  Ch_DeclareVar(
      agent->agent_interp,
      tmp_buf
      );

  tmp_buf[0] = '\0';
  sprintf(tmp_buf, "char mc_host_name[] = \"%s\";",
      agent->mc_platform->hostname );
  Ch_DeclareVar(
      agent->agent_interp,
      tmp_buf
      );

  tmp_buf[0] = '\0';
  sprintf(tmp_buf, "int mc_host_port = %d;\n",
      agent->mc_platform->port );
  Ch_DeclareVar(
      agent->agent_interp,
      tmp_buf
      );

  tmp_buf[0] = '\0';
  sprintf(tmp_buf, "int mc_task_progress = %d;\n",
      agent->datastate->task_progress);
  Ch_DeclareVar(
      agent->agent_interp,
      tmp_buf
      );

  tmp_buf[0] = '\0';
  sprintf(tmp_buf, "int mc_num_tasks = %d;\n",
      agent->datastate->number_of_tasks );
  Ch_DeclareVar(
      agent->agent_interp,
      tmp_buf
      );

  /* Declare standard error code enum */
  tmp_buf[0] = '\0';
  sprintf(tmp_buf, "enum error_code_e {MC_SUCCESS = 0, MC_ERR, MC_ERR_CONNECT, MC_ERR_PARSE, MC_ERR_EMPTY, MC_ERR_INVALID, MC_ERR_INVALID_ARGS, MC_ERR_NOT_FOUND, MC_ERR_MEMORY, MC_ERR_SEND, MC_WARN_DUPLICATE };" );
  Ch_DeclareVar(
      agent->agent_interp,
      tmp_buf
      );

  tmp_buf[0] = '\0';
  sprintf(tmp_buf, "enum MC_SteerCommand_e {MC_RUN = 0, MC_SUSPEND, MC_RESTART, MC_STOP};" );
  Ch_DeclareVar(
      agent->agent_interp,
      tmp_buf
      );

  tmp_buf[0] = '\0';
  sprintf(tmp_buf, "enum mc_AgentStatus_e { MC_WAIT_CH, MC_WAIT_MESSGSEND, MC_AGENT_ACTIVE, MC_AGENT_NEUTRAL, MC_AGENT_SUSPENDED, MC_WAIT_FINISHED};"); 
  Ch_DeclareVar(
      agent->agent_interp,
      tmp_buf
      );

  free(tmp_buf);
  /* Add the MCAgent_t typedef */
  Ch_DeclareVar(
      agent->agent_interp,
      "void* MCAgent_t;"
      );
  Ch_DeclareTypedef(
      agent->agent_interp,
      "MCAgent_t"
      );

  /* Following are the declarations of the agent-space api functions. */
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_AddAgent(void* agent);",
      (ChFuncdl_t)MC_AddAgent_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_Barrier(int id);",
      (ChFuncdl_t)MC_Barrier_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_BarrierDelete(int id);",
      (ChFuncdl_t)MC_BarrierDelete_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_BarrierInit(int id, int num_procs);",
      (ChFuncdl_t)MC_BarrierInit_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_CallAgentFunc(MCAgent_t agent, const char* funcName, void* returnVal, void* arg_struct);",
      (ChFuncdl_t)MC_CallAgentFunc_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_CondBroadCast(int id);",
      (ChFuncdl_t)MC_CondBroadcast_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_CondSignal(int id);",
      (ChFuncdl_t)MC_CondSignal_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_CondReset(int id);",
      (ChFuncdl_t)MC_CondReset_chdl 
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_CondWait(int id);",
      (ChFuncdl_t)MC_CondWait_chdl 
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_DeleteAgent(MCAgent_t agent);",
      (ChFuncdl_t)MC_DeleteAgent_chdl 
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_DeregisterService(int agentID, char* serviceName);",
      (ChFuncdl_t)MC_DeregisterService_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_End(void);",
      (ChFuncdl_t)MC_End_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "void *mc_FindAgentByID(int id);",
      (ChFuncdl_t)MC_FindAgentByID_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "void *mc_FindAgentByName(const char *name);",
      (ChFuncdl_t)MC_FindAgentByName_chdl
      );
  /* FIXME -- This block of code does not work: Ch does not
   * understand 'time_t' */
  /*
  Ch_DeclareFunc(
      agent->agent_interp,
      "time_t mc_GetAgentArrivalTime(void* agent);",
      (ChFuncdl_t)MC_GetAgentArrivalTime_chdl
      );
      */
  Ch_DeclareFunc(
      agent->agent_interp,
      "int MC_GetAgentID(void* agent);",
      (ChFuncdl_t)MC_GetAgentStatus_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "char* MC_GetAgentName(void* agent);",
      (ChFuncdl_t)MC_GetAgentStatus_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_GetAgentStatus(void* agent);",
      (ChFuncdl_t)MC_GetAgentStatus_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "char *mc_GetAgentXMLString(void* agent);",
      (ChFuncdl_t)MC_GetAgentXMLString_chdl
      );

#ifndef _WIN32
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_gettimeofday(void* tv);",
      (ChFuncdl_t)MC_GetTimeOfDay_chdl
      );
#endif

  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_HaltAgency(void);",
      (ChFuncdl_t)MC_HaltAgency_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_MutexLock(int id);",
      (ChFuncdl_t)MC_MutexLock_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_MutexUnlock(int id);",
      (ChFuncdl_t)MC_MutexUnlock_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_PrintAgentCode(void* agent);",
      (ChFuncdl_t)MC_PrintAgentCode_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_ResumeAgency(void);",
      (ChFuncdl_t)MC_ResumeAgency_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_SearchForService(const char* searchString, char*** agentNames, char*** serviceNames, int** agentIDs, int* numResults);",
      (ChFuncdl_t)MC_SearchForService_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_SendSteerCommand(enum MC_SteerCommand_e command);",
      (ChFuncdl_t)MC_SendSteerCommand_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_RegisterService(MCAgent_t agent, char **serviceNames, int numServices);",
      (ChFuncdl_t)MC_RegisterService_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "void *mc_RetrieveAgent(void);",
      (ChFuncdl_t)MC_RetrieveAgent_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "char *mc_RetrieveAgentCode(void* agent);",
      (ChFuncdl_t)MC_RetrieveAgentCode_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_SemaphoreWait(int id);",
      (ChFuncdl_t)MC_SemaphoreWait_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_SemaphorePost(int id);",
      (ChFuncdl_t)MC_SemaphorePost_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_SendAgentMigrationMessage(char *message, char *hostname, int port);",
      (ChFuncdl_t)MC_SendAgentMigrationMessage_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_SendAgentMigrationMessageFile(char *filename, char *hostname, int port);",
      (ChFuncdl_t)MC_SendAgentMigrationMessageFile_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_SetAgentStatus(void* agent, int status);",
      (ChFuncdl_t)MC_SetAgentStatus_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_SetDefaultAgentStatus(int status);",
      (ChFuncdl_t)MC_SetDefaultAgentStatus_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_SyncDelete(int id);",
      (ChFuncdl_t)MC_SyncDelete_chdl 
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_SyncInit(int id);",
      (ChFuncdl_t)MC_SyncInit_chdl 
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_TerminateAgent(void* agent);",
      (ChFuncdl_t)MC_TerminateAgent_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "int mc_GetAgentID(void* agent);",
      (ChFuncdl_t)MC_GetAgentID_chdl
      );
  Ch_DeclareFunc(
      agent->agent_interp,
      "char *mc_GetAgentName(void* agent);",
      (ChFuncdl_t)MC_GetAgentName_chdl
      );
  /* Originally, we hope to use append runscript if the buffer for code is less than 5120 bytes.
     Otherwise we must open a file and save the data to the filename.
     However, since the mobile agent codes for testing are complete programs 
     which contain preprocessing directives like "#include" and are larger than 51 bytes, we use
     the following statement to save the data to a file instead of putting it into the buffer. 

FIXME: This is silly
*/
  if(strlen(agent->datastate->agent_code) < 51)
  {
    if(Ch_AppendRunScript(
          ((MCAgent_t)ChAgent)->agent_interp, 
          ((MCAgent_t)ChAgent)->datastate->agent_code))
    {
      printf("CH Failure \n");
      exit(EXIT_FAILURE);
    }
    if(Ch_CallFuncByName(((MCAgent_t)ChAgent)->agent_interp, "main", NULL))
    {
      printf("CH2 failure \n");
      exit(EXIT_FAILURE);
    }
  }
  else
  {
    /* save the agent to an external file %agentname%%d%d */
    temp_store_file = (char *)malloc(sizeof(char)*30);

#ifndef _WIN32
    strcpy(temp_store_file, "agentchscriptXXXXXX");
    fd = mkstemp(temp_store_file);
    if (fd == -1) {
      fprintf(stderr, "Could not create temporary file:%s. %s:%d\n",
          temp_store_file,
          __FILE__,
          __LINE__ );
      exit(EXIT_FAILURE);
    }
    close(fd);
#else
    tmpnam(temp_store_file);
#endif
    TEMP_FILE = fopen(temp_store_file, "w");


    /* write the data to a ch-file */
    n = fwrite(
        (void *)agent->datastate->agent_code, 
        sizeof(char), 
        strlen(agent->datastate->agent_code), 
        TEMP_FILE);

    fclose(TEMP_FILE);

    /* set the Ch Shell arguments as appropriate */
    ChShellArg[0] = temp_store_file;
    ChShellArg[1] = NULL;
    MUTEX_LOCK(agent->run_lock);
    Ch_RunScript(agent->agent_interp, ChShellArg); 
    MUTEX_UNLOCK(agent->run_lock);

    /*        if(Ch_CallFuncByName(((MCAgent_t)ChAgent)->agent_interp, "main", NULL))
              {
              printf("CH2 failure \n");
              exit(EXIT_FAILURE);
              } */

    /* remove the temp file after its usage */
    remove(temp_store_file);
    free(temp_store_file);
  }

  /* now add the data element returned from the Ch execution into the agent data structure */
  if(strcmp(agent->datastate->tasks[progress]->var_name, "no-return"))
  {
    result = agent_return_data_InitializeFromAgent(agent);
    /* Free old result extracted from XML agent */
    agent_return_data_Destroy(
        agent->datastate->tasks[progress]->agent_return_data
        );
    /* Replace with new freshly calculated one */
    agent->datastate->tasks[progress]->agent_return_data = 
      result;
  } else {
    agent->datastate->tasks[progress]->agent_return_data = NULL;
  }

  if (agent->datastate->persistent || 
      agent->datastate->tasks[progress]->persistent ) {
    /* TODO: We need a large while loop here that waits on a condition 
       variable. Upon waking up, we will need to check a 'mailbox' for
       a struct containing
       1. A message/command
       2. A void* to generic data
       3. The size of the data.
       It should then execute the command, and check to see if the
       persistent flag is still set. If it is, loop again. 
       */
    /* For now, let us just not end the Ch interpreter and set the 
     * agent_status to MC_AGENT_NEUTRAL to cause it to hang. */
    ((MCAgent_t) ChAgent)->agent_status = MC_AGENT_NEUTRAL;
  } else {
    if ((((MCAgent_t)ChAgent)->agent_interp) != NULL) {
      Ch_End(((MCAgent_t)ChAgent)->agent_interp);
    }
    if (
        (agent->datastate->
         tasks[progress]->agent_return_data == NULL) &&
        (agent->datastate->task_progress ==
         (agent->datastate->number_of_tasks-1))
       ) 
    {
      ((MCAgent_t) ChAgent)->agent_status = MC_WAIT_FINISHED;
    }
    else {
      ((MCAgent_t) ChAgent)->agent_status = MC_WAIT_MESSGSEND; 
    }
  }

  /* close the task, indicating that it has been completed */
  agent->datastate->
    tasks[agent->datastate->task_progress]->task_completed = 1;
  agent->datastate->task_progress++;

  if (
      (agent->datastate->task_progress >= agent->datastate->number_of_tasks)
     )
  {
    agent->agent_type = MC_RETURN_AGENT;
  }

  SIGNAL(
      mc_platform->MC_signal_cond,
      mc_platform->MC_signal_lock,
      mc_platform->MC_signal = MC_EXEC_AGENT;
      );

  MUTEX_LOCK( mc_platform->MC_signal_lock);
  MUTEX_UNLOCK( mc_platform->MC_signal_lock );
  MUTEX_LOCK(mc_platform->ams->runflag_lock);
  mc_platform->ams->run = 1;
  COND_SIGNAL(mc_platform->ams->runflag_cond);
  MUTEX_UNLOCK(mc_platform->ams->runflag_lock);

#ifndef _WIN32
  pthread_exit(ChAgent);  
#else
  return 0;
#endif
}


