using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

namespace EmbeddedCh
{
    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
    public struct ChOptions_t
    {
        public int shelltype;        /*!< shell type: CH_REGULARCH or CH_SAFECH */
        /* int chrc; */
        /* deprecated, use default value */
        /* char *chrcname; */
        /* deprecated, use default value  */
        public String chhome;         /*!< Embedded Ch home directory. if NULL, use Ch home directory for 
                                    standard/professional edition as Embedded Ch home directory */
        /* char *chmtdir; */
        /* directory for dynamically loaded libs chmt1.dl, chmt2.dl etc. 
              deprecated, use default value*/
    };

    /* return type for Ch_FuncType() */
    public enum ChFuncType_t
    {
      CH_NOTFUNCTYPE,   /* not function */
      CH_FUNCTYPE,      /* regular function */
      CH_FUNCPROTOTYPE, /* function prototype without function definition */
      CH_FUNCPTRTYPE,   /* pointer to function */
      CH_FUNCMEMBERTYPE,/* member function of a class */
      CH_FUNCCONSTYPE,  /* constructor of a class */
      CH_FUNCDESTTYPE   /* destructor of a class */
    };

    /* return type for Ch_VarType () */
    public enum ChVarType_t
    {
        CH_NOTVARTYPE,     /* undefined, tag in struct tag{}; enum tag{}; typedef int tag;*/
        CH_GLOBALVARTYPE, /* global variables including functions with function definition */
        CH_LOCALVARTYPE  /* local variables including functions with function definition */
       /*  CH_FUNCPROTOTYPE obsolete */  /* function prototype without function definition */
    } ;

    /* the information for a block in Ch */
    [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
    public struct ChBlock_t {
        int event_;          /* event for callback */
        int count;          /* every 'count' instructions for callback mask CH_MASKCOUNT */
        int level;          /* int level2() {level1();} int leve1(){level0();} int leve0() {current func}. 
                               Level 0 is the current running function, whereas level n+1 
                               is the function that has called level n. */
        int linecurrent;    /* the current line num where the given function is executing. */
        int linefuncbegin;  /* the line number where the definition of the function begins. */
        int linefuncend;    /* the line number where the definition of the function ends. */
        String source; /* the file name if the source is a file, otherwise, it is a string.
                               It contains the first 70 characters beginning with  "@string: " */
        String funcname; /* function name if the block is a function, otherwise NULL */
        String classname; /* class name if it is a member function, otherwise NULL */
        int isconstructor;  /* true if it is a constructor of class, otherwise false */
        int isdestructor;   /* true if it is a destructor of class, otherwise false */
    };

    /* the information for a user defined tag of class/struct/union in Ch */
    public struct ChUserDefinedInfo_t {
        ChType_t dtype;        /* user defined data type: CH_STRUCTTYPE, CH_CLASSTYPE, CH_UNIONTYPE, or CH_UNDEFINETYPE */
        String tagname;         /* tag name */
        int size;              /* size of class/struct/union */
        int totnum;            /* total number of members in class/struct/union */
    };

    /* the information for a member of class/struct/union in Ch */
    public struct ChMemInfo_t {
        int index;             /* index number of the member */
        String memname;        /* member name */
        int offset;            /* offset of the member from the starting memory for the class/struct */
        ChType_t dtype;        /* data type of the member */
        int ispublic;          /* 1: public;         0: private */
        int isfunc;            /* 1: function type;  0: not function type */
        int ismemberfunc;      /* 1: member funct;   0: not member funct */
        int isconstructor;     /* 1: constructor;    0: not constructor */
        int isdestructor;      /* 1: destructor;     0: not destructor */
        int isvararg;          /* 1: function with variable number arguments; 0: not */
        int arraytype;         /* one of array type defined in ch.h, similar to Ch_ArrayType() */
        int dim;               /* array dim */
        [MarshalAs(UnmanagedType.ByValArray, SizeConst = 7)]
        int[] extent;         /* extent for each dimension, up to 7 */
        int isbitfield;        /* 1: bit field;      0: not bit field */
        int fieldsize;         /* struct tag{int i:3, j:10}; fieldsize of j is 10 */
        int fieldoffset;       /* struct tag{int i:3, j:10}; fieldoffset of j is 3 */
        //^^ TBD
        //ChUserDefinedTag_t udtag; /* tag for member of struct/class/union */
        IntPtr udtag; /* tag for member of struct/class/union */
    };

    //^^ TBD
    //typedef int ChFile_t;     /* file descriptor for portable file stream redirection */
    //typedef void *ChFuncdl_t; /* pointer to wrappter _chdl function  for Ch_DeclareFunc(ChInterp_t, char *, ChFuncdl_t); */
    //typedef void *ChPointer_t; /* a generic Ch pointer */
    /* call back function prototype  for Ch_AddCallback() */
    //typedef void (*ChCallback_t)(ChInterp_t interp, ChBlock_t *calldata, ChPointer_t clientdata);
    //typedef void *ChValueNode_t; /* pointer to a value node inside Ch for 
    //                            ChValueNode_t  Ch_ExprValue(ChInterp_t interp, const char *expr, void *result);
    //                            int Ch_DeleteExprValue(ChInterp_t interp, ChValueNode_t vn);*/

    /**
     * \brief   Ch shell type.
     * 
     * Used to set the shell type for the Ch interpretter.
     */
    public enum ChShellType
    {
        CH_REGULARCH = 0,   /*!< Default, regular shell */
        CH_SAFECH = 1,      /*!< Safe shell */
    }

    /* Standard file descriptors used in 2nd arg in Ch_Reopen()  */
    public enum ChFileDescriptor
    {
        STDIN_FILENO  = 0,       /* Standard input.  */
        STDOUT_FILENO = 1,       /* Standard output.  */
        STDERR_FILENO = 2,       /* Standard error output.  */
    };

    /* The mast for callback setup by Ch_AddCallback() () */
    [Flags]
    public enum ChCallbackMask
    {
        CH_MASKNONE  = 0X0000,
        CH_MASKCALL  = 0X0001,
        CH_MASKRET   = 0X0002,
        CH_MASKBLOCK = 0X0004,
        CH_MASKEND   = 0X0008,
        CH_MASKLINE  = 0X0010,
        CH_MASKCOUNT = 0X0020,
        CH_MASKABORT = 0X0040,
    }

    //^^ TBD
    /* one of possible return values of Ch_ChangeStack() */
    //#define CH_INVALIDLEVEL 2


}
