#include <stdio.h>
#include <libmc.h>
#include <fipa_acl.h>

#ifdef _WIN32
#include <windows.h>
#endif

void* stationary_agent_func(struct agent_thread_arg_s* agent_thread_arg)
{
	/* Wait for and receive a message */
	fipa_acl_message_t* acl_message;

	printf("Stationary agent online.\n");
	printf("Stationary agent waiting for ACL message...\n");
	acl_message = MC_AclWaitRetrieve(agent_thread_arg->agent);
	if (acl_message != NULL) {
		printf("Received an acl message.\n");
		sleep(1);
		printf("Acl message content is \"%s\"\n", acl_message->content->content);
	} else {
		printf("Error retrieving ACL message\n");
	}
	return NULL;
}

int main(int argc, char *argv[]) 
{
  MCAgency_t agency;
  MCAgencyOptions_t options;
  int local_port = 5051;
 
  MC_InitializeAgencyOptions(&options);
  /* If the following line is uncommented, the command prompt
   * will be disabled. */
  /*MC_SetThreadOff(&options, MC_THREAD_CP); */

  agency = MC_Initialize(local_port, &options);

	MC_AddStationaryAgent(agency, stationary_agent_func, "mobagent1", NULL);

  MC_MainLoop(agency);

  MC_End(agency);
  return 0;
}
