using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

namespace EmbeddedCh
{

    public class ChInterp
    {
        /* location of the dll wrapper */
        //private const String chdll = "embedchn.dll";
        public const String chdll = "embedchdll.dll";

        //typedef void (*ChCallback_t)(ChInterp_t interp, ChBlock_t *calldata, ChPointer_t clientdata);
        public delegate void ChCallback(IntPtr interp, ref ChBlock_t calldata, IntPtr clientdata);
        
        //typedef void *ChInterp_t;  /* pointer to  Ch interpreter structure */
        private IntPtr interp = IntPtr.Zero;

        /* Ch options struct */
        private ChOptions_t options = new ChOptions_t();
        private bool useOptions = false;

        public ChInterp()
        {
        }

        public bool UseOptions
        {
            get
            {
                return useOptions;
            }
            set
            {
                useOptions = value;
            }
        }

        public ChShellType ShellType
        {
            get
            {
                return (ChShellType)options.shelltype;
            }
            set
            {
                options.shelltype = (int)value;
            }
        }

        public String ChHome
        {
            get
            {
                return options.chhome;
            }
            set
            {
                options.chhome = value;
            }
        }

        public int Initialize()
        {
            if (!useOptions)
                return _Ch_Initialize(ref interp, IntPtr.Zero);
            else
                return _Ch_Initialize(ref interp, ref options);
        }

        public int RunScript(String[] argv)
        {
            return _Ch_RunScript(interp, argv);
        }

        public int AppendRunScript(String argv)
        {
            return _Ch_AppendRunScript(interp, argv);
        }

        public int AppendRunScriptFile(String filename)
        {
            return _Ch_AppendRunScriptFile(interp, filename);
        }

        public int InitGlobalVar(Int32 flag)
        {
            return _Ch_InitGlobalVar(interp, flag);
        }

        public int ParseScript(String[] argv)
        {
            return _Ch_ParseScript(interp, argv);
        }

        public int ExecScript(String progname)
        {
            return _Ch_ExecScript(interp, progname);
        }

        public int ExecScriptM(String progname)
        {
            return _Ch_ExecScriptM(interp, progname);
        }
        
        public int RunScriptM(String[] argv)
        {
            return _Ch_RunScriptM(interp, argv);
        }

        public int AppendParseScript(String code)
        {
            return _Ch_AppendParseScript(interp, code);
        }

        public int AppendParseScriptFile(String filename)
        {
            return _Ch_AppendParseScriptFile(interp, filename);
        }

        public int End()
        {
            int temp = _Ch_End(interp);
            interp = IntPtr.Zero;
            return temp;
        }

        /* needs help */
        public int ExprCalc(String expr, ChType_t datatype, IntPtr result)
        {
            return _Ch_ExprCalc(interp, expr, datatype, result);
        }

        public int ExprEval(String expr)
        {
            return _Ch_ExprEval(interp, expr);
        }

        public int ExprParse(String expr)
        {
            return _Ch_ExprParse(interp, expr);
        }

        /* needs help */
        public IntPtr ExprValue(String expr, IntPtr result)
        {
            return _Ch_ExprValue(interp, expr, result);
        }

        /* needs help */
        public int DeleteExprValue(IntPtr vn)
        {
            return _Ch_DeleteExprValue(interp, vn);
        }

        /* needs help */
        public Int32 SetVar(String name, ChType_t atype /*, ...  type arg */
            /* CH_CHARRAYTYPE, atype, a, dim, extent */
            /* char *tagname, void *arg */)
        {
            return _Ch_SetVar(interp, name, atype /*, ...  type arg */
            /* CH_CHARRAYTYPE, atype, a, dim, extent */
            /* char *tagname, void *arg */);
        }

        public Int32 Close(Int32 fildes)
        {
            return _Ch_Close(interp, fildes);
        }

        public Int32 Reopen(String filename, String mode, Int32 fildes)
        {
            return _Ch_Reopen(interp, filename, mode, fildes);
        }

        public Int32 Flush(Int32 fildes)
        {
            return _Ch_Flush(interp, fildes);
        }

        public Int32 Abort()
        {
            return _Ch_Abort(interp);
        }

        public Int32 DeclareVar(String declaration)
        {
            return _Ch_DeclareVar(interp, declaration);
        }

        public Int32 DeclareTypedef(String name)
        {
            return _Ch_DeclareTypedef(interp, name);
        }

        public Int32 DeclareFunc(String funcprototype, IntPtr funcptr)
        {
            return _Ch_DeclareFunc(interp, funcprototype, funcptr);
        }

        public Int32 SetGlobalUserData(IntPtr userdata)
        {
            return _Ch_SetGlobalUserData(interp, userdata);
        }

        public IntPtr GetGlobalUserData()
        {
            return _Ch_GetGlobalUserData(interp);
        }

        public Int32 AddCallback(Int32 _event, ChCallback callback,
                                 IntPtr clientdata, Int32 count)
        {
            return _Ch_AddCallback(interp, _event, callback, clientdata, count);
        }

        public Int32 ChangeStack(Int32 level, ref ChBlock_t calldata)
        {
            return _Ch_ChangeStack(interp, level, ref calldata);
        }

        public Int32 StackLevel(ref Int32 clevel, ref Int32 hlevel)
        {
            return _Ch_StackLevel(interp, ref clevel, ref hlevel);
        }

        public String StackName(Int32 level, ref Int32 isfunc, String[] classname)
        {
            return _Ch_StackName(interp, level, ref isfunc, classname);
        }

        public Int32 GlobalSymbolTotalNum()
        {
            return _Ch_GlobalSymbolTotalNum(interp);
        }

        public Int32 GlobalSymbolIndexByName(String name)
        {
            return _Ch_GlobalSymbolIndexByName(interp, name);
        }

        public IntPtr GlobalSymbolAddrByIndex(Int32 index)
        {
            return _Ch_GlobalSymbolAddrByIndex(interp, index);
        }

        public String GlobalSymbolNameByIndex(Int32 index)
        {
            return _Ch_GlobalSymbolNameByIndex(interp, index);
        }

        public ChType_t DataType(String expr)
        {
            return _Ch_DataType(interp, expr);
        }

        public Int32 DataSize(String expr)
        {
            return _Ch_DataSize(interp, expr);
        }

        public ChType_t ArrayType(String expr)
        {
            return _Ch_ArrayType(interp, expr);
        }

        public Int32 ArrayDim(String expr)
        {
            return _Ch_ArrayDim(interp, expr);
        }

        public Int32 ArrayExtent(String expr, Int32 index)
        {
            return _Ch_ArrayExtent(interp, expr, index);
        }

        public Int32 ArrayNum(String expr)
        {
            return _Ch_ArrayNum(interp, expr);
        }

        public ChVarType_t VarType(String name)
        {
            return _Ch_VarType(interp, name);
        }

        public ChFuncType_t FuncType(String name)
        {
            return _Ch_FuncType(interp, name);
        }

        public Int32 IsFuncVarArg(String name)
        {
            return _Ch_IsFuncVarArg(interp, name);
        }

        public Int32 FuncArgNum(String name)
        {
            return _Ch_FuncArgNum(interp, name);
        }

        public IntPtr SymbolAddrByName(String name)
        {
            return _Ch_SymbolAddrByName(interp, name);
        }

        public Int32 SymbolTotalNum()
        {
            return _Ch_SymbolTotalNum(interp);
        }

        public Int32 SymbolIndexByName(String name)
        {
            return _Ch_SymbolIndexByName(interp, name);
        }

        public IntPtr SymbolAddrByIndex(Int32 index)
        {
            return _Ch_SymbolAddrByIndex(interp, index);
        }

        public String SymbolNameByIndex(Int32 index)
        {
            return _Ch_SymbolNameByIndex(interp, index);
        }

        public IntPtr UserDefinedTag(String expr)
        {
            return _Ch_UserDefinedTag(interp, expr);
        }

        public Int32 UserDefinedInfo(IntPtr udtag, ref ChUserDefinedInfo_t udinfo)
        {
            return _Ch_UserDefinedInfo(interp, udtag, ref udinfo);
        }

        public Int32 UserDefinedMemInfoByName(IntPtr udtag, String memname, ref ChMemInfo_t meminfo)
        {
            return _Ch_UserDefinedMemInfoByName(interp, udtag, memname, ref meminfo);
        }

        public Int32 UserDefinedMemInfoByIndex(IntPtr udtag, Int32 index, ref ChMemInfo_t meminfo)
        {
            return _Ch_UserDefinedMemInfoByIndex(interp, udtag, index, ref meminfo);
        }

        public String UserDefinedName(String name)
        {
            return _Ch_UserDefinedName(interp, name);
        }

        public Int32 UserDefinedSize(String name)
        {
            return _Ch_UserDefinedSize(interp, name);
        }

        public ChType_t FuncArgDataType(String funcname, Int32 argnum)
        {
            return _Ch_FuncArgDataType(interp, funcname, argnum);
        }

        public ChType_t FuncArgArrayType(String funcname, Int32 argnum) /* Int32 [n], Int32 [:], Int32 &, Int32 [&] */
        {
            return _Ch_FuncArgArrayType(interp, funcname, argnum); /* Int32 [n], Int32 [:], Int32 &, Int32 [&] */
        }

        public Int32 FuncArgArrayDim(String funcname, Int32 argnum)
        {
            return _Ch_FuncArgArrayDim(interp, funcname, argnum);
        }

        public Int32 FuncArgArrayExtent(String funcname, Int32 argnum, Int32 index)
        {
            return _Ch_FuncArgArrayExtent(interp, funcname, argnum, index);
        }

        public Int32 FuncArgArrayNum(String funcname, Int32 argnum)
        {
            return _Ch_FuncArgArrayNum(interp, funcname, argnum);
        }

        public Int32 FuncArgIsFunc(String funcname, Int32 argnum)
        {
            return _Ch_FuncArgIsFunc(interp, funcname, argnum);
        }

        public Int32 FuncArgIsFuncVarArg(String funcname, Int32 argnum)
        {
            return _Ch_FuncArgIsFuncVarArg(interp, funcname, argnum);
        }

        public Int32 FuncArgFuncArgNum(String funcname, Int32 argnum)
        {
            return _Ch_FuncArgFuncArgNum(interp, funcname, argnum);
        }

        public String FuncArgUserDefinedName(String funcname, Int32 argnum)
        {
            return _Ch_FuncArgUserDefinedName(interp, funcname, argnum);
        }

        public Int32 FuncArgUserDefinedSize(String funcname, Int32 argnum)
        {
            return _Ch_FuncArgUserDefinedSize(interp, funcname, argnum);
        }

       
        ////////// embedch.h
        [DllImport(chdll, EntryPoint = "Ch_Initialize")]
        private static extern Int32 _Ch_Initialize(ref IntPtr interpp, ref ChOptions_t option);
        [DllImport(chdll, EntryPoint = "Ch_Initialize")]
        private static extern Int32 _Ch_Initialize(ref IntPtr interpp, IntPtr option);
        [DllImport(chdll, EntryPoint = "Ch_InitGlobalVar")]
        private static extern Int32 _Ch_InitGlobalVar(IntPtr interp, Int32 flag);
        [DllImport(chdll, EntryPoint = "Ch_ParseScript")]
        private static extern Int32 _Ch_ParseScript(IntPtr interp, String[] argv);
        [DllImport(chdll, EntryPoint = "Ch_ExecScript")]
        private static extern Int32 _Ch_ExecScript(IntPtr interp, String progname);
        [DllImport(chdll, EntryPoint = "Ch_ExecScriptM")]
        private static extern Int32 _Ch_ExecScriptM(IntPtr interp, String progname);
        [DllImport(chdll, EntryPoint = "Ch_RunScript")]
        private static extern Int32 _Ch_RunScript(IntPtr interp, String[] argv);
        [DllImport(chdll, EntryPoint = "Ch_RunScriptM")]
        private static extern Int32 _Ch_RunScriptM(IntPtr interp, String[] argv);
        [DllImport(chdll, EntryPoint = "Ch_AppendParseScript")]
        private static extern Int32 _Ch_AppendParseScript(IntPtr interp, String code);
        [DllImport(chdll, EntryPoint = "Ch_AppendParseScriptFile")]
        private static extern Int32 _Ch_AppendParseScriptFile(IntPtr interp, String filename);
        [DllImport(chdll, EntryPoint = "Ch_AppendRunScript")]
        private static extern Int32 _Ch_AppendRunScript(IntPtr interp, String code);
        [DllImport(chdll, EntryPoint = "Ch_AppendRunScriptFile")]
        private static extern Int32 _Ch_AppendRunScriptFile(IntPtr interp, String filename);

        [DllImport(chdll, EntryPoint = "Ch_ExprCalc")]
        private static extern Int32 _Ch_ExprCalc(IntPtr interp, String expr, ChType_t datatype, IntPtr result);
        [DllImport(chdll, EntryPoint = "Ch_ExprEval")]
        private static extern Int32 _Ch_ExprEval(IntPtr interp, String expr); /* equivalent to Ch_ExprCalc(NULL, expr, CH_VOIDTYPE,  NULL); */
        [DllImport(chdll, EntryPoint = "Ch_ExprParse")]
        private static extern Int32 _Ch_ExprParse(IntPtr interp, String expr);
        [DllImport(chdll, EntryPoint = "Ch_ExprValue")]
        private static extern IntPtr _Ch_ExprValue(IntPtr interp, String expr, IntPtr result);
        [DllImport(chdll, EntryPoint = "Ch_DeleteExprValue")]
        private static extern Int32 _Ch_DeleteExprValue(IntPtr interp, IntPtr vn);

        [DllImport(chdll, EntryPoint = "Ch_SetVar")]
        private static extern Int32 _Ch_SetVar(IntPtr interp, String name, ChType_t atype /*, ...  type arg */
                                                                        /* CH_CHARRAYTYPE, atype, a, dim, extent */
                                                                        /* char *tagname, void *arg */);
        [DllImport(chdll, EntryPoint = "Ch_Close")]
        private static extern Int32 _Ch_Close(IntPtr interp, Int32 fildes);
        [DllImport(chdll, EntryPoint = "Ch_Reopen")]
        private static extern Int32 _Ch_Reopen(IntPtr interp, String filename, String mode, Int32 fildes);
        [DllImport(chdll, EntryPoint = "Ch_Flush")]
        private static extern Int32 _Ch_Flush(IntPtr interp, Int32 fildes);
        [DllImport(chdll, EntryPoint = "Ch_End")]
        private static extern Int32 _Ch_End(IntPtr interp);
        [DllImport(chdll, EntryPoint = "Ch_Abort")]
        private static extern Int32 _Ch_Abort(IntPtr interp);
        [DllImport(chdll, EntryPoint = "Ch_DeclareVar")]
        private static extern Int32 _Ch_DeclareVar(IntPtr interp, String declaration);
        [DllImport(chdll, EntryPoint = "Ch_DeclareTypedef")]
        private static extern Int32 _Ch_DeclareTypedef(IntPtr interp, String name);
        [DllImport(chdll, EntryPoint = "Ch_DeclareFunc")]
        private static extern Int32 _Ch_DeclareFunc(IntPtr interp, String funcprototype, IntPtr funcptr);
        [DllImport(chdll, EntryPoint = "Ch_SetGlobalUserData")]
        private static extern Int32 _Ch_SetGlobalUserData(IntPtr interp, IntPtr userdata);
        [DllImport(chdll, EntryPoint = "Ch_GetGlobalUserData")]
        private static extern IntPtr _Ch_GetGlobalUserData(IntPtr interp);
        [DllImport(chdll, EntryPoint = "Ch_AddCallback")]
        private static extern Int32 _Ch_AddCallback(IntPtr interp, Int32 _event, ChCallback callback, 
                                       IntPtr clientdata, Int32 count);
        [DllImport(chdll, EntryPoint = "Ch_ChangeStack")]
        private static extern Int32 _Ch_ChangeStack(IntPtr interp, Int32 level, ref ChBlock_t calldata);
        [DllImport(chdll, EntryPoint = "Ch_StackLevel")]
        private static extern Int32 _Ch_StackLevel(IntPtr interp, ref Int32 clevel, ref Int32 hlevel);
        [DllImport(chdll, EntryPoint = "Ch_StackName")]
        private static extern String _Ch_StackName(IntPtr interp, Int32 level, ref Int32 isfunc, String[] classname);

        [DllImport(chdll, EntryPoint = "Ch_GlobalSymbolTotalNum")]
        private static extern Int32 _Ch_GlobalSymbolTotalNum(IntPtr interp);
        [DllImport(chdll, EntryPoint = "Ch_GlobalSymbolIndexByName")]
        private static extern Int32 _Ch_GlobalSymbolIndexByName(IntPtr interp, String name);
        [DllImport(chdll, EntryPoint = "Ch_GlobalSymbolAddrByIndex")]
        private static extern IntPtr _Ch_GlobalSymbolAddrByIndex(IntPtr interp, Int32 index);
        [DllImport(chdll, EntryPoint = "Ch_GlobalSymbolNameByIndex")]
        private static extern String _Ch_GlobalSymbolNameByIndex(IntPtr interp, Int32 index);

        [DllImport(chdll, EntryPoint = "Ch_DataType")]
        private static extern ChType_t _Ch_DataType(IntPtr interp, String expr);
        [DllImport(chdll, EntryPoint = "Ch_DataSize")]
        private static extern Int32 _Ch_DataSize(IntPtr interp, String expr);
        [DllImport(chdll, EntryPoint = "Ch_ArrayType")]
        private static extern ChType_t _Ch_ArrayType(IntPtr interp, String expr);
        [DllImport(chdll, EntryPoint = "Ch_ArrayDim")]
        private static extern Int32 _Ch_ArrayDim(IntPtr interp, String expr);
        [DllImport(chdll, EntryPoint = "Ch_ArrayExtent")]
        private static extern Int32 _Ch_ArrayExtent(IntPtr interp, String expr, Int32 index);
        [DllImport(chdll, EntryPoint = "Ch_ArrayNum")]
        private static extern Int32 _Ch_ArrayNum(IntPtr interp, String expr);
        [DllImport(chdll, EntryPoint = "Ch_VarType")]
        private static extern ChVarType_t _Ch_VarType(IntPtr interp, String name);

        [DllImport(chdll, EntryPoint = "Ch_FuncType")]
        private static extern ChFuncType_t _Ch_FuncType(IntPtr interp, String name);
        [DllImport(chdll, EntryPoint = "Ch_IsFuncVarArg")]
        private static extern Int32 _Ch_IsFuncVarArg(IntPtr interp, String name);
        [DllImport(chdll, EntryPoint = "Ch_FuncArgNum")]
        private static extern Int32 _Ch_FuncArgNum(IntPtr interp, String name);
        [DllImport(chdll, EntryPoint = "Ch_SymbolAddrByName")]
        private static extern IntPtr _Ch_SymbolAddrByName(IntPtr interp, String name);

        [DllImport(chdll, EntryPoint = "Ch_SymbolTotalNum")]
        private static extern Int32 _Ch_SymbolTotalNum(IntPtr interp);
        [DllImport(chdll, EntryPoint = "Ch_SymbolIndexByName")]
        private static extern Int32 _Ch_SymbolIndexByName(IntPtr interp, String name);
        [DllImport(chdll, EntryPoint = "Ch_SymbolAddrByIndex")]
        private static extern IntPtr _Ch_SymbolAddrByIndex(IntPtr interp, Int32 index);
        [DllImport(chdll, EntryPoint = "Ch_SymbolNameByIndex")]
        private static extern String _Ch_SymbolNameByIndex(IntPtr interp, Int32 index);

        [DllImport(chdll, EntryPoint = "Ch_UserDefinedTag")]
        private static extern IntPtr _Ch_UserDefinedTag(IntPtr interp, String expr);
        [DllImport(chdll, EntryPoint = "Ch_UserDefinedInfo")]
        private static extern Int32 _Ch_UserDefinedInfo(IntPtr interp, IntPtr udtag, 
                                      ref ChUserDefinedInfo_t udinfo);
        [DllImport(chdll, EntryPoint = "Ch_UserDefinedMemInfoByName")]
        private static extern Int32 _Ch_UserDefinedMemInfoByName(IntPtr interp, IntPtr udtag,
                                               String memname, ref ChMemInfo_t meminfo);
        [DllImport(chdll, EntryPoint = "Ch_UserDefinedMemInfoByIndex")]
        private static extern Int32 _Ch_UserDefinedMemInfoByIndex(IntPtr interp, IntPtr udtag,
                                                Int32 index, ref ChMemInfo_t meminfo);
        [DllImport(chdll, EntryPoint = "Ch_UserDefinedName")]
        private static extern String _Ch_UserDefinedName(IntPtr interp, String name);
        [DllImport(chdll, EntryPoint = "Ch_UserDefinedSize")]
        private static extern Int32 _Ch_UserDefinedSize(IntPtr interp, String name);

        [DllImport(chdll, EntryPoint = "Ch_FuncArgDataType")]
        private static extern ChType_t _Ch_FuncArgDataType(IntPtr interp, String funcname, Int32 argnum);
        [DllImport(chdll, EntryPoint = "Ch_FuncArgArrayType")]
        private static extern ChType_t _Ch_FuncArgArrayType(IntPtr interp, String funcname, Int32 argnum); /* Int32 [n], Int32 [:], Int32 &, Int32 [&] */
        [DllImport(chdll, EntryPoint = "Ch_FuncArgArrayDim")]
        private static extern Int32 _Ch_FuncArgArrayDim(IntPtr interp, String funcname, Int32 argnum);
        [DllImport(chdll, EntryPoint = "Ch_FuncArgArrayExtent")]
        private static extern Int32 _Ch_FuncArgArrayExtent(IntPtr interp, String funcname, Int32 argnum, Int32 index);
        [DllImport(chdll, EntryPoint = "Ch_FuncArgArrayNum")]
        private static extern Int32 _Ch_FuncArgArrayNum(IntPtr interp, String funcname, Int32 argnum);
        [DllImport(chdll, EntryPoint = "Ch_FuncArgIsFunc")]
        private static extern Int32 _Ch_FuncArgIsFunc(IntPtr interp, String funcname, Int32 argnum);
        [DllImport(chdll, EntryPoint = "Ch_FuncArgIsFuncVarArg")]
        private static extern Int32 _Ch_FuncArgIsFuncVarArg(IntPtr interp, String funcname, Int32 argnum);
        [DllImport(chdll, EntryPoint = "Ch_FuncArgFuncArgNum")]
        private static extern Int32 _Ch_FuncArgFuncArgNum(IntPtr interp, String funcname, Int32 argnum);
        [DllImport(chdll, EntryPoint = "Ch_FuncArgUserDefinedName")]
        private static extern String _Ch_FuncArgUserDefinedName(IntPtr interp, String funcname, Int32 argnum);
        [DllImport(chdll, EntryPoint = "Ch_FuncArgUserDefinedSize")]
        private static extern Int32 _Ch_FuncArgUserDefinedSize(IntPtr interp, String funcname, Int32 argnum);


        /////////////// ch.h
        [DllImport(chdll, EntryPoint = "Ch_Home")]
        private static extern String _Ch_Home(IntPtr interp);
        [DllImport(chdll, EntryPoint = "Ch_Version")]
        private static extern Int32 _Ch_Version(IntPtr interp, ChInfo_t* info);
        [DllImport(chdll, EntryPoint = "Ch_GlobalSymbolAddrByName")]
        private static extern IntPtr _Ch_GlobalSymbolAddrByName(IntPtr interp, String name);
        [DllImport(chdll, EntryPoint = "Ch_SymbolAddrByName")]
        private static extern IntPtr _Ch_SymbolAddrByName(IntPtr interp, String name);
        [DllImport(chdll, EntryPoint = "Ch_CallFuncByAddrv")]
        private static extern Int32 _Ch_CallFuncByAddrv(IntPtr interp, IntPtr fptr, IntPtr retval, va_list ap);
        [DllImport(chdll, EntryPoint = "Ch_CallFuncByNamev")]
        private static extern Int32 _Ch_CallFuncByNamev(IntPtr interp, String name, IntPtr retval, va_list ap);
        [DllImport(chdll, EntryPoint = "Ch_CallFuncByNameVar")]
        private static extern Int32 _Ch_CallFuncByNameVar(IntPtr interp, String name, IntPtr retval, ChVaList_t arglist);

        /* What to do about these? */
        //#define Ch_VaStart(list, varg) list = (ChVaList_t)varg;
        //#define Ch_VaStart(interp, list, varg) list = (ChVaList_t)__builtin_Ch_VaStart(&interp, varg);
        //#define Ch_VaArg(interp, list, type) ((type*)__builtin_Ch_VaArg(interp, (void **)&list))[0]
        //extern void *__builtin_Ch_VaStart (ChInterp_t *interp, void *varg);
        //extern void *__builtin_Ch_VaArg (ChInterp_t interp, void** list);
        
        /*
        [DllImport(chdll, EntryPoint = "Ch_VaCount")]
        private static extern Int32   _Ch_VaCount(IntPtr interp, ChVaList_t ap);
        [DllImport(chdll, EntryPoint = "Ch_VaEnd")]
        private static extern void  _Ch_VaEnd(IntPtr interp, ChVaList_t ap);
        [DllImport(chdll, EntryPoint = "Ch_VaDataType")]
        private static extern ChType_t _Ch_VaDataType(IntPtr interp, ChVaList_t ap);
        [DllImport(chdll, EntryPoint = "Ch_VaArrayType")]
        private static extern ChType_t _Ch_VaArrayType(IntPtr interp, ChVaList_t ap);
        [DllImport(chdll, EntryPoint = "Ch_VaArrayDim")]
        private static extern Int32   _Ch_VaArrayDim(IntPtr interp, ChVaList_t ap);
        [DllImport(chdll, EntryPoint = "Ch_VaArrayExtent")]
        private static extern Int32   _Ch_VaArrayExtent(IntPtr interp, ChVaList_t ap, Int32 index); /* int a[n][m]; index 0 for n, index 1 for m */
        /*[DllImport(chdll, EntryPoint = "Ch_VaArrayNum")]
        private static extern Int32   _Ch_VaArrayNum(IntPtr interp, ChVaList_t ap);
        [DllImport(chdll, EntryPoint = "Ch_VaIsFunc")]
        private static extern Int32   _Ch_VaIsFunc(IntPtr interp, ChVaList_t ap);
        [DllImport(chdll, EntryPoint = "Ch_VaIsFuncVarArg")]
        private static extern Int32   _Ch_VaIsFuncVarArg(IntPtr interp, ChVaList_t ap);
        [DllImport(chdll, EntryPoint = "Ch_VaFuncArgDataType")]
        private static extern ChType_t _Ch_VaFuncArgDataType(IntPtr interp, ChVaList_t ap, Int32 argnum);
        [DllImport(chdll, EntryPoint = "Ch_VaFuncArgNum")]
        private static extern Int32   _Ch_VaFuncArgNum(IntPtr interp, ChVaList_t ap); 
        [DllImport(chdll, EntryPoint = "Ch_VaUserDefinedAddr")]
        private static extern IntPtr _Ch_VaUserDefinedAddr(IntPtr interp, ChVaList_t ap); 
        [DllImport(chdll, EntryPoint = "Ch_VaUserDefinedName")]
        private static extern String _Ch_VaUserDefinedName(IntPtr interp, ChVaList_t ap); 
        [DllImport(chdll, EntryPoint = "Ch_VaUserDefinedSize")]
        private static extern Int32   _Ch_VaUserDefinedSize(IntPtr interp, ChVaList_t ap); 
        [DllImport(chdll, EntryPoint = "Ch_VaVarArgsCreate")]
        private static extern IntPtr _Ch_VaVarArgsCreate(IntPtr interp, ChVaList_t ap, void **memhandle);
        [DllImport(chdll, EntryPoint = "Ch_VaVarArgsDelete")]
        private static extern void  _Ch_VaVarArgsDelete(IntPtr interp, void *memhandle);
        [DllImport(chdll, EntryPoint = "Ch_VarArgsCreate")]
        private static extern ChVaList_t _Ch_VarArgsCreate(IntPtr interp);
        //[DllImport(chdll, EntryPoint = "Ch_VarArgsAddArg")]
        //private static extern Int32   _Ch_VarArgsAddArg(IntPtr interp, ChVaList_t *arglistp, ChType_t atype, ... /* type arg */ 
                                                                        /* CH_CHARRAYTYPE, atype, a, dim, extent */
                                                                        /* char *tagname, void *arg */
                                                                        /* );*/
        /*[DllImport(chdll, EntryPoint = "Ch_VarArgsAddArgExpr")]
        private static extern Int32   _Ch_VarArgsAddArgExpr(IntPtr interp, ChVaList_t *arglistp, String expr);
        [DllImport(chdll, EntryPoint = "Ch_VarArgsDelete")]
        private static extern void  _Ch_VarArgsDelete(IntPtr interp, ChVaList_t arglist);
        [DllImport(chdll, EntryPoint = "Ch_FuncArgUserDefinedSize")]

        [DllImport(chdll, EntryPoint = "Ch_Home")]
        private static extern String _Ch_Home(IntPtr interp);
        [DllImport(chdll, EntryPoint = "Ch_Version")]
        private static extern Int32 _Ch_Version(IntPtr interp, ChInfo_t* info);
        [DllImport(chdll, EntryPoint = "Ch_GlobalSymbolAddrByName")]
        private static extern IntPtr _Ch_GlobalSymbolAddrByName(IntPtr interp, String name);
        [DllImport(chdll, EntryPoint = "Ch_SymbolAddrByName")]
        private static extern IntPtr _Ch_SymbolAddrByName(IntPtr interp, String name);
        [DllImport(chdll, EntryPoint = "Ch_CallFuncByAddrv")]
        private static extern Int32 _Ch_CallFuncByAddrv(IntPtr interp, IntPtr fptr, IntPtr retval, va_list ap);
        [DllImport(chdll, EntryPoint = "Ch_CallFuncByNamev")]
        private static extern Int32 _Ch_CallFuncByNamev(IntPtr interp, String name, IntPtr retval, va_list ap);
        [DllImport(chdll, EntryPoint = "Ch_CallFuncByNameVar")]
        private static extern Int32 _Ch_CallFuncByNameVar(IntPtr interp, String name, IntPtr retval, ChVaList_t arglist);

        [DllImport(chdll, EntryPoint = "Ch_CppChangeThisPointer")]
        private static extern Int32   _Ch_CppChangeThisPointer(IntPtr interp, IntPtr thisp, size_t size); 
        [DllImport(chdll, EntryPoint = "Ch_CppIsArrayElement")]
        private static extern Int32   _Ch_CppIsArrayElement(IntPtr interp);
        */

        // Va-arg stuff
        /*
        [DllImport(chdll, EntryPoint = "Ch_CallFuncByAddr")]
        private static extern Int32   _Ch_CallFuncByAddr(IntPtr interp, IntPtr fptr, IntPtr retval, ...);
        [DllImport(chdll, EntryPoint = "Ch_CallFuncByName")]
        private static extern Int32   _Ch_CallFuncByName(IntPtr interp, String name, IntPtr retval, ...);
        */

        /* in ch.h
        extern int      Ch_CallFuncByAddr(ChInterp_t interp, void *fptr, void *retval, ...);
        extern int      Ch_CallFuncByAddrv(ChInterp_t interp, void *fptr, void *retval, va_list ap);
        extern int      Ch_CallFuncByName(ChInterp_t interp, const char *name, void *retval, ...);
        extern int      Ch_CallFuncByNamev(ChInterp_t interp, const char *name, void *retval, va_list ap);
        extern int      Ch_CallFuncByNameVar(ChInterp_t interp, const char *name, void *retval, ChVaList_t arglist);
        extern void    *Ch_GlobalSymbolAddrByName(ChInterp_t interp, const char *name);  in ch.h 
        */

    }
}
