#!/bin/ch
#include <unistd.h>   // for access() 
#include <dlfcn.h>    // for dlopen() 
#include <chshell.h>  // for chinfo() 

int addChdlHeader(char *headerfile, char *macro, char *chdlheader);
int removeMacroLine(char *headerfile, char *macro);

string_t pkgname="cs2ch"; // define package name
chinfo_t info;              // for Ch version number
string_t cwd = _cwd;        // the current working directory
string_t debugFile;         // compilation debug information in Windows
string_t debug;
string_t makecmd;
#if defined(_WIN32_)
    debug=">nul 2>nul";         // surpress messages during cleaning in Windows
    debugFile =">logfile 2>&1"; // compilation debug information in 'logfile'
    makecmd = "nmake -f Makefile.win";
#else
    makecmd = "make -f Makefile";
#endif

//make sure pgkcreate.ch is run from the current working directory
if(access("postbuild.ch", R_OK)) {
    echo Run ./pkgcreate.ch in the current directory.
    exit(-1);
}
// run this script in proper Ch version
chinfo(&info);
if ((info.vermajor*100+ info.verminor*10 +  info.vermicro) < 501) {
   echo "To run this script, you need to install Ch version 5.0.1.12201 or higher"
   echo "You can download the latest version from http://www.softintegration.com/download"
   exit(-1);
}

echo Testing .dl file ...
if (dlopen("./c/libcs2ch.dl", RTLD_LAZY) == NULL) {
    printf("Error: test of loading libcs2ch.dl: %s\n", dlerror());
    exit(-1);
}

mv -f c/libcs2ch.dl $pkgname/dl
$makecmd clean $debug
echo Package $pkgname created successfully!
