using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using LibMC;

/** \file /LibMCGui/Form1.cs
 * Program for testing miscellaneous functions in LibMC.NET.
 */

/**
 * \brief      Namespace for GUI-based Mobile-C example.
 * 
 * This program demonstrates starting an agency from a GUI as well
 * as several Mobile-C functions. It also allows the user to send
 * agents to any remote agency or load them locally. Console output
 * can be viewed in the Output Window under the heading "Debug."
 */
namespace LibMCTest
{
    /**
     * \brief   Main form class
     * 
     * This class opens a form with several controls on it for
     * the Mobile-C agency.
     */
    public partial class Form1 : Form
    {
        private MCAgency Agency = new MCAgency();
        private static int localport = 5051;
        private static int remoteport = 5050;

        /** 
         * \brief       Default constructor
         * 
         * Creates the main Form for the application.
         */
        public Form1()
        {
            InitializeComponent();
            numericUpDown1.Value = localport;
            numericUpDown2.Value = remoteport;
        }

        /** 
         * \brief       Form load event.
         * 
         * Event that fires when the form loads.
         * 
         * \param       sender Provided by the OS - the object that raised the event.
         * \param       e The arguments provided with the event.
         */
        private void Form1_Load(object sender, EventArgs e)
        {
            label3.Text = Agency.State.ToString();
        }

        /** 
         * \brief       Form closing event.
         * 
         * Event that fires when the form closes.
         * 
         * \param       sender Provided by the OS - the object that raised the event.
         * \param       e The arguments provided with the event.
         */
        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if ((Agency.State == MCAgency.MCAgencyState.Running) || 
                (Agency.State == MCAgency.MCAgencyState.Halted))
                Agency.End();
        }

        /** 
         * \brief       Button 1 click event.
         * 
         * Event that fires when button1 is clicked.
         * 
         * \param       sender Provided by the OS - the object that raised the event.
         * \param       e The arguments provided with the event.
         */
        private void button1_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = "XML files (*.xml)|*.xml|All files (*.*)|*.*";

            if (ofd.ShowDialog() == DialogResult.OK)
            {
                String filename = ofd.FileName;
                try
                {
                    Agency.SendAgentMigrationMessageFile(filename, 
                        "localhost", Agency.Port);
                }
                catch (Exception ex)
                {
                    richTextBox1.Text += "Error sending file: " + ex.Message + "\n";
                    richTextBox1.Text += "Is the local agency running?\n";
                }
            }
        }

        /** 
         * \brief       Button 2 click event.
         * 
         * Event that fires when button2 is clicked.
         * 
         * \param       sender Provided by the OS - the object that raised the event.
         * \param       e The arguments provided with the event.
         */
        private void button2_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = "XML files (*.xml)|*.xml|All files (*.*)|*.*";

            if (ofd.ShowDialog() == DialogResult.OK)
            {
                String filename = ofd.FileName;
                try
                {
                    Agency.SendAgentMigrationMessageFile(filename, 
                        textBox1.Text, (int)numericUpDown2.Value);
                }
                catch (Exception ex)
                {
                    richTextBox1.Text += "Error sending file: " + ex.Message + "\n";
                    richTextBox1.Text += "Is the local agency running?\n";
                }
            }
        }

        /** 
         * \brief       Button 3 click event.
         * 
         * Event that fires when button3 is clicked.
         * 
         * \param       sender Provided by the OS - the object that raised the event.
         * \param       e The arguments provided with the event.
         */
        private void button3_Click(object sender, EventArgs e)
        {
            int temp;

            if (Agency.State == MCAgency.MCAgencyState.Initialized)
            {
                Agency.Port = (int)numericUpDown1.Value;
                temp = Agency.SetThreadOff(MCAgency.MC_ThreadIndex_e.MC_THREAD_CP);
                if (temp != 0)
                    richTextBox1.Text += "SetThreadOff: " + temp.ToString() + "\n";
                temp = Agency.Initialize();
                if (temp != 0)
                    richTextBox1.Text += "Initialize: " + temp.ToString() + "\n";
                else
                {
                    richTextBox1.Text += "Started agency.\n";
                    button3.Text = "Halt Agency";
                }
            }
            else if (Agency.State == MCAgency.MCAgencyState.Running)
            {
                temp = Agency.HaltAgency();
                if (temp != 0)
                    richTextBox1.Text += "Error halting agency: " + 
                        temp.ToString() + "\n";
                else
                    button3.Text = "Resume Agency";
            }
            else if (Agency.State == MCAgency.MCAgencyState.Halted)
            {
                temp = Agency.ResumeAgency();
                if (temp != 0)
                    richTextBox1.Text += "Error resuming agency: " + 
                        temp.ToString() + "\n";
                else
                    button3.Text = "Halt Agency";
            }
            else
            {
                richTextBox1.Text += "Error: Agency is in an unknown state: " + 
                    Agency.State.ToString();
            }
            label3.Text = Agency.State.ToString();
        }
    }
}