/* SVN FILE INFO
 * $Revision: 249 $ : Last Committed Revision
 * $Date: 2008-12-12 17:33:25 -0800 (Fri, 12 Dec 2008) $ : Last Committed Date */
/*[
 * Copyright (c) 2007 Integration Engineering Laboratory
                      University of California, Davis
 *
 * Permission to use, copy, and distribute this software and its
 * documentation for any purpose with or without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.
 *
 * Permission to modify the software is granted, but not the right to
 * distribute the complete modified source code.  Modifications are to
 * be distributed as patches to the released version.  Permission to
 * distribute binaries produced by compiling modified sources is granted,
 * provided you
 *   1. distribute the corresponding source modifications from the
 *    released version in the form of a patch file along with the binaries,
 *   2. add special version identification to distinguish your version
 *    in addition to the base release version number,
 *   3. provide your name and address as the primary contact for the
 *    support of your modified version, and
 *   4. retain our contact information in regard to use of the base
 *    software.
 * Permission to distribute the released version of the source code along
 * with corresponding source modifications in the form of a patch file is
 * granted with same provisions 2 through 4 for binary distributions.
 *
 * This software is provided "as is" without express or implied warranty
 * to the extent permitted by applicable law.
]*/

#include <string.h>
#ifndef _WIN32
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <netdb.h>
#else
#include "winconfig.h"
#endif
#include <mxml.h>
#include "include/libmc.h"
#include "include/agent.h"
#include "include/mc_platform.h"
#include "include/message.h"
#include "include/mtp_http.h"
#include "include/xml_compose.h"
#include "include/xml_helper.h"
#include "include/xml_parser.h"

#include "security/asm_node.h"

#define SOCKET_INPUT_SIZE 4096

#ifdef MC_SECURITY
int message_Decrypt(message_p message, asm_node_p asm_node)
{
  int i;
  mxml_node_t* message_node;
  mxml_node_t* encrypted_data_node;
  mxml_node_t* gaf_message_node;
  char* encrypted_hex_string;
  unsigned char* message_string;
  char buf[3];
  unsigned char iv[32];
  int tmp = 0;
  int decrypt_len;

  gaf_message_node = mxmlFindElement
    (
     message->xml_root,
     message->xml_root,
     "MOBILEC_MESSAGE",
     NULL,
     NULL,
     MXML_DESCEND
    );
  /* Find the message element */
  message_node = mxmlFindElement
    (
     message->xml_root,
     message->xml_root,
     "MESSAGE",
     NULL,
     NULL,
     MXML_DESCEND
    );
  if (message_node == NULL) return MC_ERR_PARSE;
  encrypted_data_node = mxmlFindElement
    (
     message->xml_root,
     message_node,
     "ENCRYPTED_DATA",
     NULL,
     NULL,
     MXML_DESCEND
    );
  if (encrypted_data_node == NULL) return MC_ERR_PARSE;
  encrypted_hex_string = xml_get_text(encrypted_data_node);
  
  /* Now we need to convert the hex string into an unsigned char str. */
  message_string = (unsigned char*)malloc
    (
     sizeof(char) * 
     ((strlen(encrypted_hex_string)/2) + 32)
    );
  CHECK_NULL(message_string, exit(0););
  buf[2] = '\0';
  for(i = 0; i < (int)strlen(encrypted_hex_string); i += 2)
  {
    buf[0] = encrypted_hex_string[i];
    buf[1] = encrypted_hex_string[i+1];
    sscanf(buf, "%x", &tmp);
    message_string[i/2] = (unsigned char) tmp; 
  }

  decrypt_len = 
     strlen(encrypted_hex_string)/2;
  memset(iv, 0, sizeof(iv));
  aes_cbc_decrypt
    (
     &(asm_node->data.dh_data->aes),
     iv,
     (unsigned char*)message_string,
     (unsigned char*)message_string,
     decrypt_len
    );
  /* now we delete the old message node and compose a new one */
  mxmlDelete(message_node);

  mxmlLoadString
    (
     gaf_message_node,
     (char*)message_string,
     MXML_NO_CALLBACK
    );

  /* Free all stuff */
  free(encrypted_hex_string);
  free(message_string);

  /* re-parse the message */
  return message_xml_parse(message);
}

int
message_Encrypt(message_p message, asm_node_p asm_node)
{
  int i;
  int encrypt_len;
  mxml_node_t* message_node;
  mxml_node_t* gaf_message_node;
  mxml_node_t* encrypted_data_node;
  char* message_str;
  int message_len;
  char* encrypted_message_str;
  unsigned char iv[32];
  char buf[4];

  /* First, check to see if the xml root exists. If not, we must create it */
  if (message->xml_root == NULL) {
    message->xml_root = mxmlLoadString
      (
       NULL,
       message->message_body,
       MXML_NO_CALLBACK
      );
  }

  /* Now we can get rid of the old unencrypted message body */
  if(message->message_body) {
    free(message->message_body);
    message->message_body = NULL;
  }

  message_node = mxmlFindElement
    (
     message->xml_root,
     message->xml_root,
     "MESSAGE",
     NULL,
     NULL,
     MXML_DESCEND
    );
  if (message_node == NULL) {
    return MC_ERR_PARSE;
  }
  message_str = mxmlSaveAllocString
    (
     message_node,
     MXML_NO_CALLBACK
    );
  message_len = strlen(message_str);
  message_str = realloc(message_str, message_len + 16);
  CHECK_NULL(message_str, exit(0););

  encrypt_len = message_len + (16 - message_len%16);
  memset(iv, 0, sizeof(iv));
  aes_cbc_encrypt
    (
     &(asm_node->data.dh_data->aes),
     iv,
     (unsigned char*) message_str,
     (unsigned char*) message_str,
     encrypt_len
    );
  encrypted_message_str = (char*) malloc
    (
     sizeof(char) * 
     (encrypt_len*2)+1
    );
  CHECK_NULL(encrypted_message_str, exit(0););


  encrypted_message_str[0] = '\0';
  buf[2] = '\0';
  for (i = 0; i < encrypt_len ; i++) 
  {
    sprintf(buf, "%02x", (unsigned char)message_str[i]);
    strcat(encrypted_message_str, buf);
  }

  /* Now we delete the old message node and replace it with a new one */
  mxmlDelete(message_node);
  gaf_message_node = mxmlFindElement
    (
     message->xml_root,
     message->xml_root,
     "MOBILEC_MESSAGE",
     NULL,
     NULL,
     MXML_DESCEND
    );

  message_node = mxmlNewElement
    (
     gaf_message_node,
     "MESSAGE"
    );
  mxmlElementSetAttr
    (
     message_node,
     "message",
     "ENCRYPTED_DATA"
    );
  mxmlElementSetAttr
    (
     message_node,
     "from",
     message->from_address
    );

  encrypted_data_node = mxmlNewElement
    (
     message_node,
     "ENCRYPTED_DATA"
    );
  
  xml_new_cdata
    (
     encrypted_data_node,
     encrypted_message_str
    );

  message->message_body = mxmlSaveAllocString
    (
     message->xml_root,
     MXML_NO_CALLBACK
    );

  free(message_str);
  free(encrypted_message_str);

  message->message_type = ENCRYPTED_DATA;

  return MC_SUCCESS;
}
#endif /*MC_SECURITY*/

message_p
message_New(void)
{
  message_p message;
  message = (message_p)malloc(sizeof(message_t));
  CHECK_NULL(message, exit(0););
  message->addr = NULL;
  message->connect_id = 0;
  message->message_id = 0;
  message->isHTTP = 0;
  message->message_type = 0;
  message->http_type = 0;
  message->xml_root = NULL;
  message->xml_payload = NULL;
  message->message_body = NULL;
  message->update_name = NULL;
  message->update_num = 0;
  message->from_address = NULL;
  message->to_address = NULL;
  message->target = NULL;
  message->agent_xml_flag = 0;
  return message;
}

message_p
message_Copy(message_p src)
{
  fprintf(stderr, "FIXME: message_Copy() is not implemented yet. %s:%d\n",
      __FILE__, __LINE__);
  return NULL;
}

int
message_InitializeFromAgent(
    mc_platform_p mc_platform,
    message_p message,
    agent_p agent)
{
  struct hostent* host;

  char* buf;
  char* destination_host;
  char* destination_port_str;
#ifndef _WIN32
  char* save_ptr; /* For re-entrant strtok_r */
#endif
  int destination_port;

  message->message_id = rand();
  message->message_type = MOBILE_AGENT;

  message->xml_root = agent_xml_compose(agent);
  /* If agent_xml_compose fails, that is a fatal error, since
   * 'agent' is gauranteed to be a valid agent. */
  CHECK_NULL(message->xml_root, exit(0););
  message->message_body = mxmlSaveAllocString( 
      message->xml_root,
      MXML_NO_CALLBACK );

  message->update_name = NULL;

  message->from_address =
    (char*)malloc(sizeof(char) * (strlen(mc_platform->hostname) + 10));
  sprintf(
      message->from_address,
      "%s:%d",
      mc_platform->hostname,
      mc_platform->port );
  if (
      agent->datastate->task_progress >=
      agent->datastate->number_of_tasks
     )
  {
    message->to_address = 
      (char*)malloc
      (
       sizeof(char) * 
       (
        strlen(agent->home) + 1
       )
      );
    CHECK_NULL(message->to_address, exit(0););
    strcpy
      (
       message->to_address,
       agent->home
      );
  } else {
    message->to_address = 
      (char*) malloc
      ( 
       sizeof(char) * 
       (
        strlen
        (
         agent->datastate->tasks[ agent->datastate->task_progress ]
         ->server_name 
        )
        +1
       )
      );
    CHECK_NULL( message->to_address, mc_platform->err = MC_ERR_MEMORY; return MC_ERR_MEMORY;);
    strcpy(
        message->to_address,
        agent->datastate->tasks[ agent->datastate->task_progress ]->server_name 
        );
  }
  message->agent_xml_flag = 0;
  message->target = strdup("ams");
  /* Set up message->addr */
  buf = (char*)malloc
    (
     sizeof(char) * 
     (strlen(message->to_address)+1)
    );
  CHECK_NULL(buf, exit(0););
  strcpy(buf, message->to_address);
  destination_host = strtok_r(buf, ":", &save_ptr);
  destination_port_str = strtok_r(NULL, ":", &save_ptr);
  destination_port = atoi(destination_port_str);
  message->addr = (struct sockaddr_in*)malloc(sizeof(struct sockaddr_in));
  if ((host = gethostbyname(destination_host))) {
    memcpy(&(message->addr->sin_addr), host->h_addr, host->h_length);
    message->addr->sin_port = htons(destination_port);
  } else {
    WARN("Host not found.");
  }
  free(buf);
  return MC_SUCCESS;
}

int
message_InitializeFromConnection(
    mc_platform_p mc_platform,
    message_p message,
    connection_p connection)
{
  int i = 1;
  int n;
  char *message_string;
  char *buffer;

  message->addr = (struct sockaddr_in*)malloc(sizeof(struct sockaddr_in));
  CHECK_NULL(message->addr, exit(0););
  *(message->addr) = connection->addr;

  message->connect_id = connection->connect_id;

  message->message_id = rand();

  message->to_address = NULL;
  message->from_address = NULL;
  message->target = NULL;

  buffer = (char*) malloc(sizeof(char) * (SOCKET_INPUT_SIZE + 1));
  CHECK_NULL(buffer, exit(0););
  message_string = (char*) malloc(sizeof(char) * (SOCKET_INPUT_SIZE + 1));
  CHECK_NULL(message_string, exit(0););
  message_string[0] = '\0';
  buffer[0] = '\0';

  /* Receive the message */
  while(1) {
#ifndef _WIN32
    n = recvfrom(connection->clientfd,
        (void *) buffer,
        (size_t) sizeof(char)*SOCKET_INPUT_SIZE,
        0,
        (struct sockaddr *) 0,
        (socklen_t *) 0);
#else
    n = recvfrom(connection->clientfd,
        (void *) buffer,
        (size_t) sizeof(char)*SOCKET_INPUT_SIZE,
        0,
        (struct sockaddr *) 0,
        0);
#endif
    if (n < 0) {
      free(buffer);
      return MC_ERR_CONNECT;
    } 
    else if (n == 0) {
      free(buffer);
      break;
    } else {
      buffer[n] = '\0';
      i++;
      strcat(message_string, buffer);
      message_string = realloc
        (
         message_string, 
         sizeof(char) * (SOCKET_INPUT_SIZE+1) * i
        );
      CHECK_NULL(message_string, exit(0););
      buffer[0] = '\0';
    }
  }
  message->message_body = (char*)malloc
    (
     sizeof(char) * 
     (strlen(message_string) + 1)
    );
  CHECK_NULL(message->message_body, exit(0););
  strcpy(message->message_body, message_string);
  free(message_string);
  message->xml_root = mxmlLoadString
    (
     NULL, 
     message->message_body,
     MXML_NO_CALLBACK
    );
  if (message_xml_parse(message)) {
    fprintf(stderr, "Error parsing message at %s:%d.\n",
        __FILE__, __LINE__);
    message_Destroy(message);
    return MC_ERR_PARSE;
  }
  return MC_SUCCESS;  
}

int http_to_hostport(const char* http_str, char** host, int* port, char** target)
{
  /* We want to convert the string "http://somehost.com:5050/acc" to a 
   * host: somehost.com
   * port: 5050
   * target: acc */
  char* tmp;
  if(strncmp(http_str, "http://", 7)) {
    return MC_ERR_PARSE;
  }
  http_str += 7;
  tmp = strchr(http_str, (int)':');
  if (tmp == NULL) return MC_ERR_PARSE;

  /* Get the host */
  *host = (char*)malloc(sizeof(char) * 
      (tmp - http_str + 1) );
  strncpy(*host, http_str, tmp - http_str);
  (*host)[tmp-http_str] = '\0';

  /* Get the port */
  tmp++;
  sscanf(tmp, "%d", port);

  /* Get the target */
  tmp = strchr(tmp, (int)'/');
  tmp++;
  *target = (char*)malloc(sizeof(char) * 
      (strlen(tmp)+1) );
  strcpy(*target, tmp);

  return 0;
}

int
message_InitializeFromString(
    mc_platform_p mc_platform,
    message_p message,
    const char* string,
    const char* destination_host,
    int destination_port,
    const char* target)
{
  char* destination;
  struct hostent* host;

  message->connect_id = 0;
  message->message_id = rand();

  message->message_type = MOBILE_AGENT;

  message->xml_root = NULL;

  message->message_body = 
    (char*)malloc( sizeof(char) * (strlen(string)+1));
  CHECK_NULL(message->message_body, 
      mc_platform->err = MC_ERR_MEMORY;
      return MC_ERR_MEMORY; );
  strcpy(message->message_body, string);

  message->update_name = NULL;

  destination = malloc(sizeof(char)*(strlen(destination_host) + 10));
  CHECK_NULL(destination,
      mc_platform->err = MC_ERR_MEMORY;
      return MC_ERR_MEMORY; );
  sprintf(destination, "%s:%d", 
      destination_host,
      destination_port
      );

  message->to_address = destination;
  message->from_address = (char*)malloc(
      sizeof(char) * (strlen(mc_platform->hostname)+10));
  sprintf(message->from_address,
      "%s:%d",
      mc_platform->hostname,
      mc_platform->port );
  message->target = (char*)malloc(sizeof(char) * 
      (strlen(target)+1));
  strcpy(message->target, target);

  /* Set up message->addr */
  message->addr = (struct sockaddr_in*)malloc(sizeof(struct sockaddr_in));
  if (destination_host != NULL && strlen(destination_host)!= 0) {
    if((host = gethostbyname(destination_host)))
    {
      memcpy(&(message->addr->sin_addr), host->h_addr, host->h_length);
      message->addr->sin_port = htons(destination_port);
    } else {
      fprintf(stderr, "Warning: Host not found: %s:%d  %s:%d",
          destination_host, destination_port, __FILE__, __LINE__ );
    }
  }
  message->xml_root = mxmlLoadString
    (
     NULL, 
     message->message_body,
     MXML_NO_CALLBACK
    );
  if (message_xml_parse(message)) {
    fprintf(stderr, "Error parsing message at %s:%d.\n",
        __FILE__, __LINE__);
    message_Destroy(message);
    return MC_ERR_PARSE;
  }

  return MC_SUCCESS;
}

  int
message_Destroy(message_p message)
{
  if (message == NULL) {
    return MC_SUCCESS;
  }
  /* We may not want to delete this here,
   * in case an agent needs this data. */
  if(message->xml_root != NULL && message->agent_xml_flag == 0) {
    mxmlDelete(message->xml_root);
  }

  if(message->addr) {
    free(message->addr);
    message->addr = NULL;
  }
  if(message->message_body != NULL) {
    free(message->message_body);
    message->message_body = NULL;
  }
  if(message->update_name != NULL) {
    free(message->update_name);
  }
  if(message->from_address != NULL) {
    free(message->from_address);
  }
  if(message->to_address != NULL) {
    free(message->to_address);
  }
  if(message->target != NULL) {
    free(message->target);
  }

  free(message);
  message = NULL;
  return MC_SUCCESS;
}

  int
message_Send(message_p message)
{
  char *buffer;
  mtp_http_t* mtp_http;
  int n;
#ifndef _WIN32
  int skt;
  struct sockaddr_in sktin;
#else
  SOCKET skt;
  SOCKADDR_IN sktin;
#endif
  struct hostent *host;
  char *buf;
  char *hostname;
#ifndef _WIN32
  char *saveptr; /* For reentrant strtok_r */
#endif
  int port;

  /* Compose the http message */
  if (
      mtp_http_ComposeMessage(
        message
        )
     )
  {
     return MC_ERR;
  }

  /* We need to split up the address into a hostname and port. */
  buf = (char*)malloc(sizeof(char)*(strlen(message->to_address)+1));
  strcpy(buf, message->to_address);
  hostname = strtok_r(buf, ":", &saveptr);
  sscanf( strtok_r(NULL, ":", &saveptr), "%d", &port );

  if((skt = socket(PF_INET, SOCK_STREAM, 0)) < 0) 
  { 
    fprintf(stderr, "Error - can't create socket\n");
    return -1;
  }

  memset(&sktin, 0, sizeof(sktin));
  sktin.sin_family = PF_INET;
  sktin.sin_port = htons(port);

  if((host = gethostbyname(hostname))) 
  {
    memcpy(&sktin.sin_addr, host->h_addr, host->h_length);
  }
  else if((sktin.sin_addr.s_addr = inet_addr(hostname)) < 0) 
  {
    fprintf(stderr, "Error - can't get host entry for %s\n", hostname);
    free(buf);
    return -1;
  }

  if(connect(skt, (struct sockaddr *) &sktin, sizeof(sktin)) < 0) {
    fprintf(stderr, "Error - can't connect to %s:%d\n",
        hostname,
        port
        );
    free(buf);
    return MC_ERR_CONNECT;
  }
  /* now send the string */
  if(send(skt, message->message_body, strlen(message->message_body), 0) < 0) 
  {
    fprintf(stderr, "cannot write to socket %s:%d\n",
        __FILE__, __LINE__);
#ifndef _WIN32
    close(skt);
#else
    closesocket(skt);
#endif
    free(buf);
    return MC_ERR_SEND;
  }
  /* Now we should receive an HTTP response */
  buffer = (char*) malloc(sizeof(char) * (SOCKET_INPUT_SIZE + 1));
  CHECK_NULL(buffer, exit(0););
  mtp_http = mtp_http_New();
#ifndef _WIN32
  n = recvfrom(skt,
      (void *) buffer,
      (size_t) sizeof(char)*SOCKET_INPUT_SIZE,
      0,
      (struct sockaddr *) 0,
      (socklen_t *) 0);
#else
  n = recvfrom(skt,
      (void *) buffer,
      (size_t) sizeof(char)*SOCKET_INPUT_SIZE,
      0,
      (struct sockaddr *) 0,
      0);
#endif
  if( mtp_http_Parse(mtp_http, buffer) ) {
    fprintf(stderr, "http parsing error: Response expected. %s:%d\n",
        __FILE__, __LINE__);
    fprintf(stderr, "Received message was:\n%s\n", buffer);
  }
  if (mtp_http->response_code != 200) {
    fprintf(stderr, "Warning: remote http server responded: %d %s\n",
        mtp_http->response_code, mtp_http->response_string );
  }

  mtp_http_Destroy(mtp_http);

#ifndef _WIN32
  close(skt);
#else
  closesocket(skt);
#endif
  free(buf);
  free(buffer);
  return 0;
}


