#!/bin/ch
#include <unistd.h>   // for access() 
#include <dlfcn.h>    // for dlopen() 
#include <chshell.h>  // for chinfo() 

int addChdlHeader(char *headerfile, char *macro, char *chdlheader);
int removeMacroLine(char *headerfile, char *macro);

string_t pkgname="cs2ch"; // define package name
chinfo_t info;              // for Ch version number
string_t cwd = _cwd;        // the current working directory
string_t debugFile;         // compilation debug information in Windows
string_t debug;
string_t makecmd;
#if defined(_WIN32_)
    debug=">nul 2>nul";         // surpress messages during cleaning in Windows
    debugFile =">logfile 2>&1"; // compilation debug information in 'logfile'
    makecmd = "nmake -f Makefile.win";
#else
    makecmd = "make -f Makefile";
#endif

//make sure pgkcreate.ch is run from the current working directory
if(access("prebuild.ch", R_OK)) {
    echo Run ./prebuild.ch in the current directory.
    exit(-1);
}
// run this script in proper Ch version
chinfo(&info);
if ((info.vermajor*100+ info.verminor*10 +  info.vermicro) < 501) {
   echo "To run this script, you need to install Ch version 5.0.1.12201 or higher"
   echo "You can download the latest version from http://www.softintegration.com/download"
   exit(-1);
}

echo clean up existing directory and create new ones
if (!access(pkgname, F_OK))
  rm -rf $pkgname
if (!access("demos", F_OK))
  rm -rf demos
if (!access("include", F_OK))
  rm -rf include
if (!access("chfcreate", F_OK))
  rm -rf chfcreate

mkdir $pkgname 
mkdir include demos chfcreate
mkdir $pkgname/dl $pkgname/lib $pkgname/include $pkgname/demos $pkgname/bin

echo copying src files to include in package ...
cp src/cs2ch.h include/

echo copying demo programs ...
cp -rf demos/* $pkgname/demos
chmod 744 $pkgname/demos/*.c

echo copying and modifying header files ...
cp include/cs2ch.h $pkgname/include
char *macro ="#define CS2CH_H";
char *chdlheader =
   "\n\n"
   "#ifdef _CH_\n"
   "#pragma package <cs2ch> \n"
   "#include <chdl.h> \n"
   "LOAD_CHDL(cs2ch);\n"
   "#endif \n\n";
addChdlHeader(stradd(pkgname, "/include/cs2ch.h"), macro, chdlheader);

macro ="#pragma importf";
removeMacroLine(stradd(pkgname, "/include/cs2ch.h"), macro);

echo extracting function prototypes ... 
processhfile("EXPORTCH", 0,  ";",  stradd(pkgname, "/include/cs2ch.h"), "chfcreate/cs2ch.h", NULL);
echo generating cs2ch_chdl.c in src/ and *.chf in $pkgname/lib
if (!access("chfcreate/sample_err", F_OK))
  rm -rf chfcreate/sample_err
touch chfcreate/sample_err
c2chf chfcreate/cs2ch.h -h _Chcs2ch_handle -r chfcreate/sample_err -o c c -o chf $pkgname/lib 
chmod 644 $pkgname/lib/*.chf

/*******************************************************************
 * * This function will add the required preprocessing directives
 * * needed by Ch to a header file.
 * * headerfile:   header file to be changed
 * * macro:        token to be recoganized for insertion of chdlheader
 * * chdlheader:   preprocessing directives to be inserted
 * *******************************************************************/
int addChdlHeader(char *headerfile, char *macro, char *chdlheader)
{
   char *stop_ptr;
   string_t tempfile, token;
   string_t result;
   FILE *stream;

   tempfile = ``cat $headerfile``;
   token = strstr( tempfile, macro);
   stop_ptr = strstr(token, "\n");
   strncpy(result, tempfile, strlen(tempfile)-strlen(stop_ptr));
   result=stradd(result, chdlheader);
   result=stradd(result, stop_ptr);
   if(!(stream = fopen("_tmpfile", "w")))
   {
      perror("_tmpfile");
      return -1;
   }
   fprintf(stream, "%s", result);
   fclose(stream);
   mv -f _tmpfile $(headerfile)
   return 0;
}

/*******************************************************************
 * * This function will add the to modify .h file to use .dl file 
 * * instead of using #pragma importf "x.h". Removes entire lines
 * * beginning with "macro".
 * * headerfile:   header file to be changed
 * * macro:        token to be recoganized for insertion of chdlheader
 * *******************************************************************/
int removeMacroLine(char *headerfile, char *macro)
{
   char *stop_ptr;
   string_t tempfile, token;
   string_t result;
   FILE *stream;

   // Todo: make a loop to remove all lines beginning with "macro", not just the first one.
   tempfile = ``cat $headerfile``;
   token = strstr( tempfile, macro);
   stop_ptr = strstr(token, "\n");
   strncpy(result, tempfile, strlen(tempfile)-strlen(token));
   result=stradd(result, stop_ptr);
   if(!(stream = fopen("_tmpfile", "w")))
   {
      perror("_tmpfile");
      return -1;
   }
   fprintf(stream, "%s", result);
   fclose(stream);
   mv -f _tmpfile $(headerfile)

   return 0;
}

