/************************************************************
* File: cs2chfunc.c
* This file contains function definitions for the cs2ch
* library
************************************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "cs2ch.h"    /* header file for cs2ch lib */

/* Macro for safe string copy under Windows */
#ifdef _CH_
#define strcpy_s(dest, len, src) strcpy(dest, src)
#endif

// A function pointer for the callback.
Fx fptr = NULL;

// Static variables to show persistence of the library in memory.
int count = 0;
struct1_t *dll_s1 = NULL;
struct2_t *dll_s2 = NULL;
char* n1 = "Name 1";
char* n2 = "Name 2";

/* This is an optional function for Windows only that 
   allows you to specify DLL entry and exit routines */
/*
#ifdef _WIN32
#include <windows.h>
BOOL WINAPI DllMain(
  HANDLE hinstDLL, 
  DWORD dwReason, 
  LPVOID lpvReserved
)
{
    setbuf(stdout, NULL);
    setbuf(stderr, NULL);
	printf("Dll main running.\n");
	fflush(stdout);
    count = 0;
	return TRUE; // Return FALSE to abort loading library
}
#endif
*/

EXPORTCH int setCallback(Fx f)
{
	if (f != NULL)
	{
		fptr = f;
        return TRUE;
	}
    else
    {
        return FALSE;
    }
}

EXPORTCH int callFptr(char* s)
{
	int i = 0;
	if (fptr != NULL)
	{
        if (s != NULL)
        {
            i = (*fptr)(s);
            printf("Returned %i\n", i);
            fflush(stdout);
        }
	}
    else
    {
        fprintf(stderr, "Callback function pointer not set!\n");
        fflush(stderr);
    }
    return i;
}

EXPORTCH int get_inc_int(void)
{
    printf("Count = %i.\n", count);
    fflush(stdout);
    return count++;
}

EXPORTCH int get_int(void)
{
    printf("Count = %i.\n", count);
    fflush(stdout);
    return count;
}

EXPORTCH int dll_init(void)
{
	count = 0;

	dll_s1 = (struct1_t*) malloc(sizeof(struct1_t));
	dll_s1->d = 0;
	dll_s1->i = 0;
	dll_s1->uses = -1;
	dll_s1->name = n1;
	memset(dll_s1->iarr, -1, sizeof(dll_s1->iarr));

	dll_s2 = (struct2_t*) malloc(sizeof(struct2_t));
	dll_s2->d = 3.14159;
	dll_s2->i = 314159;
	dll_s2->uses = 0;
	dll_s2->s = dll_s1;
	dll_s2->name = n2;
	memset(dll_s2->iarr, -1, sizeof(dll_s2->iarr));
    
    return count;
}

EXPORTCH int dll_exit(void)
{
	if (dll_s1 != NULL)
		free(dll_s1);
	if (dll_s2 != NULL)
		free(dll_s2);
    return count;
}

EXPORTCH int add(int a, int b)
{
	int retval;
	retval = a + b;
	printf("In sum: a = %i, b = %i\n", a, b);
	printf("Returning %i\n", retval);
	fflush(stdout);

	fprintf(stderr, "This is an error.\n");
	fflush(stderr);

	return retval;
}

EXPORTCH double doublesum(double a, double b)
{
	double retval;
	printf("In sum: a = %lf, b = %lf\n", a, b);
	retval = a + b;
	printf("Returning %lf\n", retval);
	fflush(stdout);
	return retval;
}

EXPORTCH int func1(struct1_t s1, struct2_t s2)
{
	int retval;
	printf("In func1: s1.i = %i, s2.i = %i\n", s1.i, s2.i);
	retval = s1.i + s2.i;
	printf("Returning %i\n", retval);

	s1.uses++;
	s2.uses++;

	fflush(stdout);
	return retval;
}

EXPORTCH double func2(struct1_t *s1, struct2_t *s2)
{
	double retval;
	printf("In func1: s1->d = %lf, s2->d = %lf\n", s1->d, s2->d);
	retval = s1->d + s2->d;
	printf("Returning %lf\n", retval);

	s1->uses++;
	s2->uses++;

	fflush(stdout);
	return retval;
}

EXPORTCH struct2_t* func3(struct1_t* s1)
{
	if (s1 != NULL)
	{
		struct2_t* s2 = (struct2_t*) malloc(sizeof(struct2_t));
		s2->d = s1->d;
		s2->i = s1->i;
		s2->uses = s1->uses;
		memcpy(s2->iarr, s1->iarr, sizeof(s1->iarr));
		s2->s = s1;
		if (s1->name != NULL)
		{
			s2->name = (char*)malloc(strlen(s1->name) + 1);
			strcpy_s(s2->name, strlen(s1->name) + 1, s1->name);
		}
		else
		{
			s2->name = NULL;
		}

		s1->uses++;

		return s2;
	}
	else
		return NULL;
}

EXPORTCH struct1_t* new_struct1(void)
{
	struct1_t* s = (struct1_t*) malloc(sizeof(struct1_t));
	if (s != NULL)
	{
		count++;
		s->d = 3.14;
		s->i = 314;
		s->uses = -1;
		s->name = n1;
		memset(s->iarr, -1, sizeof(s->iarr));
	}
	return s;
}

EXPORTCH void free_struct1(struct1_t* s)
{
	if (s != NULL)
		free(s);
}

EXPORTCH void free_struct2(struct2_t* s)
{
	if (s != NULL)
	{
		if (s->name != NULL)
			free(s->name);
		free(s);
	}
}
