/*************************************************************
* File: cs2ch.c
* This program demonstrates interfacing Ch and C#
*************************************************************/
#include <stdio.h>
#ifdef _CH_
#pragma package <cs2ch>
#endif

#include "cs2ch.h"

/* Load code from file cs2chfunc.c for Ch */
#ifdef _CH_
//#pragma importf "cs2chfunc.c"
#endif

/* A message to show the difference between C/C# and Ch. */
char* msg = 
#ifdef _CH_ 
    "Hello in Ch!";
#else
    "Hello from C!";
#endif

int CALLBACK callback(char* s)
{
    if (s != NULL)
    {
        printf("This is the callback: %s\n", s);
        return 123;
    }
    else
        return 0;
}

int main()
{
    printf("Static int in library: %i\n", get_inc_int());
    printf("Setting call back pointer in library.\n");
    setCallback(callback);
    printf("Calling call back in library.\n");
    callFptr(msg);
    printf("Static int in library: %i\n", get_inc_int());
    
    return 0;
}
