#!/bin/ch
#include <unistd.h>   // for access() 
#include <stdio.h>
#include <string.h>
#include <stdbool.h>

int addChdlHeader(char *headerfile, char *macro, char *chdlheader);
int removeMacroLine(char *headerfile, char *macro);
int RemExtraWhiteSpace(char* s);
int CleanUpFile(char *infile, char* outfile);

int main(int argc, char **argv)
{
   char usage[] = 
      "Usage: pkginstall.ch [-u] [-d directory] package\n"
      "       -u             uninstall 'package'\n"
      "       -d directory   directory to install 'package'\n"
      "       Examples:\n" 
      "         (1) uninstallation:\n" 
      "               pkginstall.ch -u chpng \n"
      "         (2) installation to the default directory:\n" 
      "               pkginstall.ch chpng\n"
      "         (3) installation to your preferred directory:\n" 
      "               pkginstall.ch -d /your/preferred/directory chpng\n";

    string_t cwd = _cwd;        // the current working directory
    string_t debugFile;         // compilation debug information in Windows
    string_t debug;
    string_t infile = "src/include/libmc.h";
    string_t outfile = "libmc.exports.h";
    char *s;

    argc--; argv++;
    while (argc > 0 && **argv == '-')
    {
        for (s = argv[0] + 1; *s && *s !=' '; s++)  /* empty space not valid option */
        {
            switch (*s)
            {
                case 'i':
                    argc--; argv++;
                    infile = *argv;
                    break;
                case 'o':             /* the directory to install package */
                    argc--; argv++;
                    outfile = *argv;
                    break;
                case 'h':
                    fprintf(stderr,usage);
                    break;
                default:
                    fprintf(stderr,"Warning: invalid option %c\n\n", *s);
                    break;
            }
        }
        argc--; argv++;
    } 

    printf("Opening input file %s.\n", infile);
    char *macro = "EXPORTMC";
    char *end = ";";

    processhfile(macro, 0,  end,  infile, outfile, NULL);

    printf("done...\n");
}

/*******************************************************************
 * * This function will add the required preprocessing directives
 * * needed by Ch to a header file.
 * * headerfile:   header file to be changed
 * * macro:        token to be recoganized for insertion of chdlheader
 * * chdlheader:   preprocessing directives to be inserted
 * *******************************************************************/
int addChdlHeader(char *headerfile, char *macro, char *chdlheader)
{
   char *stop_ptr;
   string_t tempfile, token;
   string_t result;
   FILE *stream;

   tempfile = ``cat $headerfile``;
   token = strstr( tempfile, macro);
   stop_ptr = strstr(token, "\n");
   strncpy(result, tempfile, strlen(tempfile)-strlen(stop_ptr));
   result=stradd(result, chdlheader);
   result=stradd(result, stop_ptr);
   if(!(stream = fopen("_tmpfile", "w")))
   {
      perror("_tmpfile");
      return -1;
   }
   fprintf(stream, "%s", result);
   fclose(stream);
   mv -f _tmpfile $(headerfile)
   return 0;
}

/*******************************************************************
 * * This function will add the to modify .h file to use .dl file 
 * * instead of using #pragma importf "x.h". Removes entire lines
 * * beginning with "macro".
 * * headerfile:   header file to be changed
 * * macro:        token to be recoganized for insertion of chdlheader
 * *******************************************************************/
int removeMacroLine(char *headerfile, char *macro)
{
   char *stop_ptr;
   string_t tempfile, token;
   string_t result;
   FILE *stream;

   // Todo: make a loop to remove all lines beginning with "macro", not just the first one.
   tempfile = ``cat $headerfile``;
   token = strstr( tempfile, macro);
   stop_ptr = strstr(token, "\n");
   strncpy(result, tempfile, strlen(tempfile)-strlen(token));
   result=stradd(result, stop_ptr);
   if(!(stream = fopen("_tmpfile", "w")))
   {
      perror("_tmpfile");
      return -1;
   }
   fprintf(stream, "%s", result);
   fclose(stream);
   mv -f _tmpfile $(headerfile)

   return 0;
}
