/**
* \file cs2ch.h 
* Header file for example package that shows how to interface
* Ch and C#.
*/
#ifndef CS2CH_H
#define CS2CH_H

#ifndef _CH_
#include <ch.h>
#endif

/* Null, just in case */
#ifndef NULL
#define NULL ((void*)0)
#endif

/* define boolean numbers */
#define TRUE 1
#define FALSE 0

/* Calling convention definition for different platforms */
#ifdef _CH_
#define CALLBACK
#define EXPORTCH
#endif

#define ARR_SZ 8

/* Typedef for structs */
/**
 * \brief		A structure to use as an example.
 *
 * A very simple structure.
 */
typedef struct arg_struct_s{
    int a;
    int b;
} arg_struct;

/**
 * \brief		A structure to use as an example.
 *
 * This structure includes several fields that can
 * be handled automatically by the marshaling services.
 */
typedef struct struct1_s
{
	int i;				/*!< An integer */
	double d;			/*!< A double */
	int iarr[ARR_SZ];	/*!< A fixed length array */
	int uses;			/*!< Another integer */
	char* name;			/*!< A character pointer (string) */
} struct1_t;

/**
 * \brief		A structure to use as an example.
 *
 * This structure includes several fields that can
 * be handled automatically by the marshaling services,
 * but also includes a pointer to a struct1_s.
 */
typedef struct struct2_s
{
	int i;					/*!< An integer */
	double d;				/*!< A double */
	int iarr[ARR_SZ];		/*!< A fixed length array */
	struct struct1_s* s;	/*!< A pointer to a struct1_s */
	int uses;				/*!< Another integer */
	char* name;				/*!< A character pointer (string) */
} struct2_t;

/**
 * \brief		A typedef for callbacks 
 *
 * Callback signature for functions returning an
 * int and taking a char* as an argument.
 */
typedef int (CALLBACK *Fx)(char*);

/**
 * \brief		A more complicated typedef for callbacks 
 *
 * Callback signature for functions returning an
 * int and taking a arg_struct* as an argument.
 */
typedef int (CALLBACK *Fy)(arg_struct*);

/* Exported functions */
EXPORTCH int add(int a, int b);
EXPORTCH int func1(struct1_t s1, struct2_t s2);
EXPORTCH double func2(struct1_t *s1, struct2_t *s2);
EXPORTCH struct2_t* func3(struct1_t* s1);
EXPORTCH struct2_t* func4(struct1_t s1);
EXPORTCH struct1_t* new_struct1(void);
EXPORTCH arg_struct* new_arg_struct(void);
EXPORTCH void free_struct1(struct1_t* s);
EXPORTCH void free_struct2(struct2_t* s);
EXPORTCH int setFxCallback(Fx f);
EXPORTCH int callFxCallback(char* s);
EXPORTCH int setFyCallback(Fy f);
EXPORTCH int callFyCallback(arg_struct* s);
EXPORTCH int get_inc_int(void);
EXPORTCH int get_int(void);
EXPORTCH double doublesum(double a, double b);
EXPORTCH int dll_init(void);
EXPORTCH int dll_exit(void);

#endif /* CS2CH_H */
