/* File: stationary_agent_communication/server.c */

#include <stdio.h>
#include <libmc.h>
#include <fipa_acl.h>

#ifdef _WIN32
#include <windows.h>
#endif

#ifndef _WIN32
void* stationary_agent_func(struct agent_thread_arg_s* agent_thread_arg)
#else
DWORD WINAPI stationary_agent_func(struct agent_thread_arg_s* agent_thread_arg)
#endif
{
  /* Wait for and receive a message */
  fipa_acl_message_t* acl_message;
  fipa_acl_message_t* reply_message;

  printf("Stationary agent online.\n");
  printf("Stationary agent waiting for ACL message...\n");
  acl_message = MC_AclWaitRetrieve(agent_thread_arg->agent);
  if (acl_message != NULL) {
    printf("Received an ACL message.\n");
#ifndef _WIN32
    sleep(1);
#else
	Sleep(1000);
#endif
    printf("ACL message content is \"%s\"\n", acl_message->content->content);
    printf("Composing a reply to the message...\n");
    reply_message = MC_AclReply(acl_message);
    MC_AclSetPerformative(reply_message, FIPA_INFORM);
    MC_AclSetSender(reply_message, "mobagent2", "http://localhost:5051/acc");
    MC_AclSetContent(reply_message, "Hello to you too, mobagent1!");
    MC_AclSend(agent_thread_arg->attr, reply_message);
  } else {
    printf("Error retrieving ACL message\n");
  }
  return NULL;
}

int main() 
{
  MCAgency_t agency;
  MCAgencyOptions_t options;
  int local_port = 5051;

  MC_InitializeAgencyOptions(&options);
  /* If the following line is uncommented, the command prompt
   * will be disabled. */
  MC_SetThreadOff(&options, MC_THREAD_CP); 

  agency = MC_Initialize(local_port, &options);

  MC_AddStationaryAgent(agency, stationary_agent_func, "mobagent2", NULL);

  MC_MainLoop(agency);

  MC_End(agency);
  return 0;
}
