/* File: mc_array_return_example/client.c */

#include <libmc.h>
#include <stdio.h>
#ifdef _WIN32
#include <windows.h>
#endif
int main(int argc, char *argv[])
{
    MCAgency_t agency;
    MCAgent_t agent;
    int *extent;
    int dim;
    short *array;
    int i, size;
    char *xml;
    MCAgencyOptions_t options;
    int port = 5051;
    int remote_port = 5050;

    MC_InitializeAgencyOptions(&options);
    MC_SetThreadOff(&options, MC_THREAD_CP); /* Turn off command prompt */
    if (argc == 2) {
        printf("Starting agency listening on port %d.\n",
                atoi(argv[1]) );
        agency = MC_Initialize(
                atoi(argv[1]),
                &options
                );
    } else {
        agency = MC_Initialize(
                port,
                &options);
    }
 /* Note: The third argument of the following function may also be a
    valid IP address in the form of a string. i.e. 192.168.0.1 */
    MC_SendAgentMigrationMessageFile(
            agency,
            "agent.xml",
            "localhost",
            remote_port); 
    while(1) {
        printf("Waiting for agent return...\n");
        MC_WaitSignal(
                agency,
                MC_RECV_RETURN
                );
        agent = MC_FindAgentByName(agency, "mobagent1");
        if (agent == NULL) {
            printf("Found wrong agent. Waiting again...\n");
            MC_ResetSignal(agency);
            continue;
        }
        if (MC_GetAgentType(agent) != MC_RETURN_AGENT) {
            printf("Found wrong agent. Waiting again...\n");
            MC_ResetSignal(agency);
            continue;
        } else {
            break;
        }
    }
    /* Get and print the agent's XML code */
    xml = MC_GetAgentXMLString(agent);
    printf("%s\n", xml);
    free(xml);

    /* Retrieve the agent's return data */
    MC_GetAgentReturnData(agent, 0, (void**)&array, &dim, &extent);

    /* Since we have previously called MC_WaitSignal(), we must now reset 
     * the signal to allow the agency to continue. */
    MC_ResetSignal(agency);

    /* Print relevant data */
    printf("dim is %d\n", dim);
    printf("Extents are: ");
    size = 1;
    for (i = 0; i < dim; i++) {
        printf("%d ", extent[i]);
        size *= extent[i];
    }
    printf("\n");
    printf("%d Elements: \n", size);
    for (i = 0; i < size; i++) {
        printf("%d ", array[i]);
    }
    printf("\n");

    MC_End(agency);

    return 0;
}

