using System;
using System.Collections.Generic;
using System.Text;

namespace EmbeddedCh
{
    /* for Ch_Version(interp, &info); Ch Professional v5.5.0.13151 */
    public struct ChInfo_t {
       String edition;            /* "Professional", "Standard" */
       String releasedate;        /* "March 17, 2005" */
       String version;            /* "", "Beta", or "Alpha" */
       uint vermajor;    /* 5 */
       uint verminor;    /* 5 */
       uint vermicro;    /* 0 */
       uint verbuild;    /* 13151 */
    };

    /* data type in Ch */
    public enum ChType_t {
        CH_UNDEFINETYPE,/* undefined type */
        /* simple type */
        CH_CHARTYPE=10, /* char */
        CH_UCHARTYPE,   /* unsigned char */
        CH_SHORTTYPE,   /* short */
        CH_USHORTTYPE,  /* unsigned short */
        CH_INTTYPE,     /* int, long int */
        CH_UINTTYPE,    /* unsigned int, unsigned long int */
        CH_LLINTTYPE,   /* long long int */
        CH_ULLINTTYPE,  /* unsigned long long int */
        CH_FLOATTYPE,   /* float */
        CH_DOUBLETYPE,  /* double */
        CH_LDOUBLETYPE, /* long double */
        CH_COMPLEXTYPE, /* float complex */
        CH_LCOMPLEXTYPE,/* double complex */
        CH_STRINGTYPE,  /* string_t type */
        CH_FILETYPE,    /* FILE */
        CH_VOIDTYPE,    /* void */
        CH_PROCTYPE,    /* function type */
        CH_STRUCTTYPE,  /* struct */
        CH_CLASSTYPE,   /* class */
        CH_UNIONTYPE,   /* union */
        CH_ENUMTYPE,    /* enum */

    /* returned Ch array type for Ch_VaArrayType(), Ch_ArrayType(), and Ch_FuncArgArrayType() */
    /* CH_CARRAYTYPE and CH_CHARRAYTYPE are also used in ChVarArgsAddArg() and Ch_SetVar() */
    /* Ch_VarArgsAddArg(&arglist, CH_CARRAYTYPE, CH_INTTYPE, a, dim, extent, ...) */
    /* Ch_VarArgsAddArg(&arglist, CH_CHARRAYTYPE, CH_INTTYPE, a, dim, extent, ...) */
        CH_CARRAYTYPE=80,  /* int a[3] */
        CH_CARRAYPTRTYPE,  /* int f(int (*ap)[3]); Ch_FuncArgDataType(ap) is CH_INTTYPE, 
                               Ch_FuncArgArrayType(ap) is CH_CARRAYPTRTYPE */
                           /* int (*p)[3]); p is pointer to int when not inside a function arg, 
                              Ch_DataType(p) is CH_INTPTRTYPE, Ch_ArrayType(ap) is CH_UNDEFINETYPE */
        CH_CARRAYVLATYPE,  /* int a[n]; int func(int a[n], int b[:], int c[&]) */
        CH_CHARRAYTYPE,    /* array int a[3] */
        CH_CHARRAYPTRTYPE, /* array int (*ap)[3] */
        CH_CHARRAYVLATYPE, /* array int a[n]; int fun(array int a[n], array int b[:], array int c[&]) */

        /* pointer */
        CH_NULLTYPE = 100, /* NULL */
        CH_VOIDPTRTYPE,    /* void* */
        CH_CHARPTRTYPE,    /* char* */
        CH_UCHARPTRTYPE,   /* unsigned char* */
        CH_SHORTPTRTYPE,   /* short* */
        CH_USHORTPTRTYPE,  /* unsigned short* */
        CH_INTPTRTYPE,     /* int*, long int * */
        CH_UINTPTRTYPE,    /* unsigned int*, unsigned long int * */
        CH_LLINTPTRTYPE,   /* long long int* */
        CH_ULLINTPTRTYPE,  /* unsigned long long int* */
        CH_FLOATPTRTYPE,   /* float* */
        CH_DOUBLEPTRTYPE,  /* double* */
        CH_LDOUBLEPTRTYPE, /* long double* */
        CH_COMPLEXPTRTYPE, /* float complex* */
        CH_LCOMPLEXPTRTYPE,/* double complex* */
        CH_STRINGPTRTYPE,  /* string_t * */
        CH_PROCPTRTYPE,    /* function ptr type */
        CH_FILEPTRTYPE,    /* FILE * */
        CH_STRUCTPTRTYPE,  /* struct * */
        CH_CLASSPTRTYPE,   /* class* */
        CH_UNIONPTRTYPE,   /* union * */
        CH_ENUMPTRTYPE,    /* enum * */

        /* double pointer */
        CH_VOIDPTR2TYPE=200,/* void** */
        CH_CHARPTR2TYPE,    /* char** */
        CH_UCHARPTR2TYPE,   /* unsigned char** */
        CH_SHORTPTR2TYPE,   /* short** */
        CH_USHORTPTR2TYPE,  /* unsigned short** */
        CH_INTPTR2TYPE,     /* int*, long int** */
        CH_UINTPTR2TYPE,    /* unsigned int**, unsigned long int** */
        CH_LLINTPTR2TYPE,   /* long long int** */
        CH_ULLINTPTR2TYPE,  /* unsigned long long int** */
        CH_FLOATPTR2TYPE,   /* float** */
        CH_DOUBLEPTR2TYPE,  /* double** */
        CH_LDOUBLEPTR2TYPE, /* long double** */
        CH_COMPLEXPTR2TYPE, /* float complex** */
        CH_LCOMPLEXPTR2TYPE,/* double complex** */
        CH_STRINGPTR2TYPE,  /* string_t ** */
        CH_FILEPTR2TYPE,    /* FILE ** */
        CH_STRUCTPTR2TYPE,  /* struct ** for now */
        CH_CLASSPTR2TYPE,   /* class ** */
        CH_UNIONPTR2TYPE,    /* union ** */
        CH_ENUMPTR2TYPE     /* enum ** */
    };

    /* the return value for APIs of int type */
    public enum ChRetVal
    {
        CH_OK    = 0,
        CH_ERROR = -1,
        CH_ABORT = 1,
    };
}
