#pragma once

#include <windows.h>

/**
 * \brief      Namespace for GUI-based VC++ example.
 * 
 * This program demonstrates starting an agency from a GUI using VC++ as
 * well as several Mobile-C functions.
 */
namespace LibMCCppEx {

    using namespace System;
    using namespace System::ComponentModel;
    using namespace System::Collections;
    using namespace System::Windows::Forms;
    using namespace System::Data;
    using namespace System::Drawing;
    using namespace LibMC;
    using namespace System::Diagnostics;

    /// <summary>
    /// Constructor for the form.
    ///
    /// WARNING: If you change the name of this class, you will need to change the
    ///          'Resource File Name' property for the managed resource compiler tool
    ///          associated with all .resx files this class depends on.  Otherwise,
    ///          the designers will not be able to interact properly with localized
    ///          resources associated with this form.
    /// </summary>
    public ref class Form1 : public System::Windows::Forms::Form
    {
    public:
        Form1(void)
        {
            InitializeComponent();
            //
            //TODO: Add the constructor code here
            //
            Agency = gcnew MCAgency();
            AllocConsole();
        }

    protected:
        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        ~Form1()
        {
            if (components)
            {
                delete components;
            }
        }
    private: System::Windows::Forms::GroupBox^  groupBox1;
    protected: 
    private: System::Windows::Forms::Button^  button1;
    private: System::Windows::Forms::NumericUpDown^  numericUpDown1;
    private: System::Windows::Forms::Label^  label2;
    private: System::Windows::Forms::Label^  label1;
    private: LibMC::MCAgency^ Agency;
    private: System::Windows::Forms::RichTextBox^  richTextBox1;
    private: System::Windows::Forms::GroupBox^  groupBox2;
    private: System::Windows::Forms::TextBox^  textBox1;
    private: System::Windows::Forms::Button^  button2;
    private: System::Windows::Forms::NumericUpDown^  numericUpDown2;
    private: System::Windows::Forms::Label^  label5;
    private: System::Windows::Forms::Label^  label4;
    private: System::Windows::Forms::Button^  button3;
    private: System::Windows::Forms::Label^  label3;

    private:
        /// <summary>
        /// Required designer variable.
        /// </summary>
        System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        void InitializeComponent(void)
        {
            this->groupBox1 = (gcnew System::Windows::Forms::GroupBox());
            this->button3 = (gcnew System::Windows::Forms::Button());
            this->button1 = (gcnew System::Windows::Forms::Button());
            this->numericUpDown1 = (gcnew System::Windows::Forms::NumericUpDown());
            this->label2 = (gcnew System::Windows::Forms::Label());
            this->label3 = (gcnew System::Windows::Forms::Label());
            this->label1 = (gcnew System::Windows::Forms::Label());
            this->richTextBox1 = (gcnew System::Windows::Forms::RichTextBox());
            this->groupBox2 = (gcnew System::Windows::Forms::GroupBox());
            this->textBox1 = (gcnew System::Windows::Forms::TextBox());
            this->button2 = (gcnew System::Windows::Forms::Button());
            this->numericUpDown2 = (gcnew System::Windows::Forms::NumericUpDown());
            this->label5 = (gcnew System::Windows::Forms::Label());
            this->label4 = (gcnew System::Windows::Forms::Label());
            this->groupBox1->SuspendLayout();
            (cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->numericUpDown1))->BeginInit();
            this->groupBox2->SuspendLayout();
            (cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->numericUpDown2))->BeginInit();
            this->SuspendLayout();
            // 
            // groupBox1
            // 
            this->groupBox1->Controls->Add(this->button3);
            this->groupBox1->Controls->Add(this->button1);
            this->groupBox1->Controls->Add(this->numericUpDown1);
            this->groupBox1->Controls->Add(this->label2);
            this->groupBox1->Controls->Add(this->label3);
            this->groupBox1->Controls->Add(this->label1);
            this->groupBox1->Dock = System::Windows::Forms::DockStyle::Top;
            this->groupBox1->Location = System::Drawing::Point(0, 0);
            this->groupBox1->Name = L"groupBox1";
            this->groupBox1->Size = System::Drawing::Size(483, 84);
            this->groupBox1->TabIndex = 0;
            this->groupBox1->TabStop = false;
            this->groupBox1->Text = L"Local Agency";
            // 
            // button3
            // 
            this->button3->Location = System::Drawing::Point(212, 50);
            this->button3->Name = L"button3";
            this->button3->Size = System::Drawing::Size(107, 23);
            this->button3->TabIndex = 4;
            this->button3->Text = L"Load Agent";
            this->button3->UseVisualStyleBackColor = true;
            this->button3->Click += gcnew System::EventHandler(this, &Form1::button3_Click);
            // 
            // button1
            // 
            this->button1->Location = System::Drawing::Point(212, 21);
            this->button1->Name = L"button1";
            this->button1->Size = System::Drawing::Size(107, 23);
            this->button1->TabIndex = 3;
            this->button1->Text = L"Start Agency";
            this->button1->UseVisualStyleBackColor = true;
            this->button1->Click += gcnew System::EventHandler(this, &Form1::button1_Click);
            // 
            // numericUpDown1
            // 
            this->numericUpDown1->Location = System::Drawing::Point(86, 24);
            this->numericUpDown1->Maximum = System::Decimal(gcnew cli::array< System::Int32 >(4) {65535, 0, 0, 0});
            this->numericUpDown1->Minimum = System::Decimal(gcnew cli::array< System::Int32 >(4) {1, 0, 0, 0});
            this->numericUpDown1->Name = L"numericUpDown1";
            this->numericUpDown1->Size = System::Drawing::Size(120, 20);
            this->numericUpDown1->TabIndex = 2;
            this->numericUpDown1->Value = System::Decimal(gcnew cli::array< System::Int32 >(4) {5050, 0, 0, 0});
            // 
            // label2
            // 
            this->label2->AutoSize = true;
            this->label2->Location = System::Drawing::Point(96, 55);
            this->label2->Name = L"label2";
            this->label2->Size = System::Drawing::Size(100, 13);
            this->label2->TabIndex = 1;
            this->label2->Text = L"Agency uninitialized";
            // 
            // label3
            // 
            this->label3->AutoSize = true;
            this->label3->Location = System::Drawing::Point(11, 55);
            this->label3->Name = L"label3";
            this->label3->Size = System::Drawing::Size(79, 13);
            this->label3->TabIndex = 0;
            this->label3->Text = L"Agency Status:";
            // 
            // label1
            // 
            this->label1->AutoSize = true;
            this->label1->Location = System::Drawing::Point(12, 26);
            this->label1->Name = L"label1";
            this->label1->Size = System::Drawing::Size(68, 13);
            this->label1->TabIndex = 0;
            this->label1->Text = L"Agency Port:";
            // 
            // richTextBox1
            // 
            this->richTextBox1->Dock = System::Windows::Forms::DockStyle::Fill;
            this->richTextBox1->Location = System::Drawing::Point(0, 170);
            this->richTextBox1->Name = L"richTextBox1";
            this->richTextBox1->Size = System::Drawing::Size(483, 202);
            this->richTextBox1->TabIndex = 1;
            this->richTextBox1->Text = L"";
            // 
            // groupBox2
            // 
            this->groupBox2->Controls->Add(this->textBox1);
            this->groupBox2->Controls->Add(this->button2);
            this->groupBox2->Controls->Add(this->numericUpDown2);
            this->groupBox2->Controls->Add(this->label5);
            this->groupBox2->Controls->Add(this->label4);
            this->groupBox2->Dock = System::Windows::Forms::DockStyle::Top;
            this->groupBox2->Location = System::Drawing::Point(0, 84);
            this->groupBox2->Name = L"groupBox2";
            this->groupBox2->Size = System::Drawing::Size(483, 86);
            this->groupBox2->TabIndex = 2;
            this->groupBox2->TabStop = false;
            this->groupBox2->Text = L"Remote Agency";
            // 
            // textBox1
            // 
            this->textBox1->Location = System::Drawing::Point(107, 50);
            this->textBox1->Name = L"textBox1";
            this->textBox1->Size = System::Drawing::Size(100, 20);
            this->textBox1->TabIndex = 8;
            this->textBox1->Text = L"localhost";
            // 
            // button2
            // 
            this->button2->Location = System::Drawing::Point(212, 17);
            this->button2->Name = L"button2";
            this->button2->Size = System::Drawing::Size(107, 23);
            this->button2->TabIndex = 4;
            this->button2->Text = L"Send Agent";
            this->button2->UseVisualStyleBackColor = true;
            this->button2->Click += gcnew System::EventHandler(this, &Form1::button2_Click);
            // 
            // numericUpDown2
            // 
            this->numericUpDown2->Location = System::Drawing::Point(86, 19);
            this->numericUpDown2->Maximum = System::Decimal(gcnew cli::array< System::Int32 >(4) {65535, 0, 0, 0});
            this->numericUpDown2->Minimum = System::Decimal(gcnew cli::array< System::Int32 >(4) {1, 0, 0, 0});
            this->numericUpDown2->Name = L"numericUpDown2";
            this->numericUpDown2->Size = System::Drawing::Size(120, 20);
            this->numericUpDown2->TabIndex = 7;
            this->numericUpDown2->Value = System::Decimal(gcnew cli::array< System::Int32 >(4) {5051, 0, 0, 0});
            // 
            // label5
            // 
            this->label5->AutoSize = true;
            this->label5->Location = System::Drawing::Point(11, 53);
            this->label5->Name = L"label5";
            this->label5->Size = System::Drawing::Size(90, 13);
            this->label5->TabIndex = 5;
            this->label5->Text = L"Agency Location:";
            // 
            // label4
            // 
            this->label4->AutoSize = true;
            this->label4->Location = System::Drawing::Point(11, 22);
            this->label4->Name = L"label4";
            this->label4->Size = System::Drawing::Size(68, 13);
            this->label4->TabIndex = 6;
            this->label4->Text = L"Agency Port:";
            // 
            // Form1
            // 
            this->AutoScaleDimensions = System::Drawing::SizeF(6, 13);
            this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
            this->ClientSize = System::Drawing::Size(483, 372);
            this->Controls->Add(this->richTextBox1);
            this->Controls->Add(this->groupBox2);
            this->Controls->Add(this->groupBox1);
            this->Name = L"Form1";
            this->Text = L"VC++ to LibMC.NET Test";
            this->Load += gcnew System::EventHandler(this, &Form1::Form1_Load);
            this->FormClosing += gcnew System::Windows::Forms::FormClosingEventHandler(this, &Form1::Form1_FormClosing);
            this->groupBox1->ResumeLayout(false);
            this->groupBox1->PerformLayout();
            (cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->numericUpDown1))->EndInit();
            this->groupBox2->ResumeLayout(false);
            this->groupBox2->PerformLayout();
            (cli::safe_cast<System::ComponentModel::ISupportInitialize^  >(this->numericUpDown2))->EndInit();
            this->ResumeLayout(false);

        }
#pragma endregion
    /** 
     * \brief       Button 1 click event.
     * 
     * Event that fires when button1 is clicked. It starts, pauses, or resumes
     * the agency.
     * 
     * \param       sender Provided by the OS - the object that raised the event.
     * \param       e The arguments provided with the event.
     */
    private: System::Void button1_Click(System::Object^  sender, 
                 System::EventArgs^  e)
    {
        int temp;

        if (Agency->State == MCAgency::MCAgencyState::Initialized)
        {
            Agency->Port = (int)numericUpDown1->Value;
            temp = Agency->SetThreadOff(MCAgency::MC_ThreadIndex_e::MC_THREAD_CP);
            if (temp != 0)
                richTextBox1->Text += "SetThreadOff: " + temp.ToString() + "\n";
            temp = Agency->Initialize();
            if (temp != 0)
                richTextBox1->Text += "Initialize: " + temp.ToString() + "\n";
            else
            {
                richTextBox1->Text += "Started agency\n";
                button1->Text = "Halt Agency";
            }
        }
        else if (Agency->State == MCAgency::MCAgencyState::Running)
        {
            temp = Agency->HaltAgency();
            if (temp != 0)
                richTextBox1->Text += "Error halting agency: " + 
                    temp.ToString() + "\n";
            else
                button1->Text = "Resume Agency";
        }
        else if (Agency->State == MCAgency::MCAgencyState::Halted)
        {
            temp = Agency->ResumeAgency();
            if (temp != 0)
                richTextBox1->Text += "Error resuming agency: " + 
                    temp.ToString() + "\n";
            else
                button1->Text = "Halt Agency";
        }
        else
        {
            richTextBox1->Text += "Error: Agency is in an unknown state: " + 
                Agency->State.ToString();
        }
        label2->Text = Agency->State.ToString();
    }
/** 
 * \brief       Form load event.
 * 
 * Event that fires when the form loads.
 * 
 * \param       sender Provided by the OS - the object that raised the event.
 * \param       e The arguments provided with the event.
 */
private: System::Void Form1_Load(System::Object^  sender, System::EventArgs^  e) {
            label2->Text = Agency->State.ToString();
         }
/** 
 * \brief       Form closing event.
 * 
 * Event that fires when the form closes.
 * 
 * \param       sender Provided by the OS - the object that raised the event.
 * \param       e The arguments provided with the event.
 */
private: System::Void Form1_FormClosing(System::Object^  sender, 
             System::Windows::Forms::FormClosingEventArgs^  e) {
             if ((Agency->State == MCAgency::MCAgencyState::Running) || 
                (Agency->State == MCAgency::MCAgencyState::Halted))
                Agency->End();
         }
private: System::Void button2_Click(System::Object^  sender, 
            System::EventArgs^  e) {
            OpenFileDialog^ ofd = gcnew OpenFileDialog();
            ofd->Filter = "XML files (*.xml)|*.xml|All files (*.*)|*.*";

            if (ofd->ShowDialog() == System::Windows::Forms::DialogResult::OK)
            {
                String^ filename = ofd->FileName;
                try
                {
                    Agency->SendAgentMigrationMessageFile(filename, 
                        textBox1->Text, (int)numericUpDown2->Value);
                }
                catch (Exception ^ex)
                {
                    richTextBox1->Text += "Error sending file: " + 
                        ex->Message + "\n";
                    richTextBox1->Text += "Is the local agency running?\n";
                }
            }
         }
private: System::Void button3_Click(System::Object^  sender, 
            System::EventArgs^  e) {
            OpenFileDialog^ ofd = gcnew OpenFileDialog();
            ofd->Filter = "XML files (*.xml)|*.xml|All files (*.*)|*.*";

            if (ofd->ShowDialog() == System::Windows::Forms::DialogResult::OK)
            {
                String^ filename = ofd->FileName;
                try
                {
                    Agency->SendAgentMigrationMessageFile(filename, 
                        "localhost", (int)numericUpDown2->Value);
                }
                catch (Exception ^ex)
                {
                    richTextBox1->Text += "Error sending file: " + 
                        ex->Message + "\n";
                    richTextBox1->Text += "Is the local agency running?\n";
                }
            }
         }
};
}

