#include <stdio.h>
#include <stdlib.h>
#include <libmc.h>
#include <fipa_acl.h>

void* stationary_agent_func(struct agent_thread_arg_s* agent_thread_arg)
{
  /* Wait for and receive a message */
  fipa_acl_message_t* acl_message;

  printf("Stationary agent online.\n");
  printf("Creating a new ACL Message...\n");
  acl_message = MC_AclNew();
  MC_AclSetPerformative(acl_message, FIPA_INFORM);
  MC_AclSetSender(acl_message, "mobagent1", "http://localhost:5050/acc");
  MC_AclAddReceiver(acl_message, "mobagent2", "http://localhost:5051/acc");
  MC_AclSetContent(acl_message, "Hello mobagent2");
  printf("Sending ACL Message...\n");
  MC_AclSend(agent_thread_arg->attr, acl_message);
  printf("Waiting for reply...\n");
  acl_message = MC_AclWaitRetrieve(agent_thread_arg->agent);
  if (acl_message != NULL) {
    printf("Received an acl message.\n");
    sleep(1);
    printf("Acl message content is \"%s\"\n", acl_message->content->content);
  } else {
    printf("Error retrieving ACL message\n");
  }

  return NULL;
}

int main(int argc, char *argv[]) 
{
  MCAgency_t agency;
  MCAgencyOptions_t options;
  int port=5050;
  int remote_port1=5051;

  MC_InitializeAgencyOptions(&options);
  MC_SetThreadOff(&options, MC_THREAD_CP); /* Turn off command prompt */
  agency = MC_Initialize(port, &options);

  /* Note: The third argument of the following function may also be a
     valid IP address in the form of a string. i.e. 192.168.0.1 */
  MC_AddStationaryAgent(agency, stationary_agent_func, "mobagent1", NULL);

  MC_MainLoop(agency);

  MC_End(agency);
  return 0;
}
