/* mc_sample_app.c
 *
 * This sample program uses the Mobile C library to build
 * a simple command-line driven client/server app. 
 * 
 * 12/15/2006
 * */

#ifndef _WIN32
#include <libmc.h>
#else
#include <libmc.h>
#include <windows.h>
#endif
#include <stdio.h>
#ifndef _WIN32
#include <unistd.h>
#endif

int main(int argc, char *argv[])
{
  /* Init the agency */
  MCAgency_t agency;
  MCAgencyOptions_t options;
  int port=5051;
  int remote_port=5050;

  MC_InitializeAgencyOptions(&options);
  MC_SetThreadOff(&options, MC_THREAD_CP); /* Turn off command prompt */
  agency = MC_Initialize(port, &options);

  /* Note: The third argument of the following function may also be a
     valid IP address in the form of a string. i.e. 192.168.0.1 */
  MC_SendAgentMigrationMessageFile(
      agency,
      "comm_agent.xml",
      "localhost",
      remote_port);
#ifndef _WIN32
  sleep(1);
#else
  Sleep(1000);
#endif
  /* Note: The third argument of the following function may also be a
     valid IP address in the form of a string. i.e. 192.168.0.1 */
  MC_SendAgentMigrationMessageFile(
      agency,
      "agent_1.xml",
      "localhost",
      remote_port);
#ifndef _WIN32
  sleep(1);
#else
  Sleep(1000);
#endif
  /* Note: The third argument of the following function may also be a
     valid IP address in the form of a string. i.e. 192.168.0.1 */
  MC_SendAgentMigrationMessageFile(
      agency,
      "agent_2.xml",
      "localhost",
      remote_port);

  MC_End(agency);
  return 0;
}
