using System;
using System.Collections.Generic;
using System.Text;
using LibMC;
using System.Threading;
using System.Runtime.InteropServices;

/** \file /LibMCConsole/Program.cs
 * Program for starting a Mobile-C agency from a console. Also
 * attempts to find "mobagent1" repeatedly and display its information.
 */

/**
 * \brief      Namespace for the LibMCConsole test program.
 * 
 * This program demonstrates how to start an agency, find an agent,
 * use the Mobile-C command line. Also demonstrates how to terminate
 * an agent.
 */
namespace LibMCConsole
{
    /**
     * \brief     Class for the main program.
     * 
     * Contains the Main function and variables, structs, etc. used
     * by the program.
     */
    class Program
    {
        public static MCAgency Agency = new MCAgency();
        public static int localport = 5050;
        public static int remoteport = 5051;

        /**
         * \brief     Main program for a general console program.
         * 
         * Creates an agency and hosts agents. It also looks for an agent
         * named "mobagent1" and displays information about the agent. 
         * Demonstrates terminating an agent, waiting on agency signals, 
         * and basic agency operations.
         */
        static void Main(string[] args)
        {
            int temp;
            MCAgent agent;

            Console.WriteLine("Starting Mobile-C on port " + 
                localport.ToString() + ".\n");

            Agency.Port = localport;
            temp = Agency.Initialize();
            if (temp != 0)
                Console.WriteLine("Initialize: " + temp.ToString() + "\n");

            while (true)
            {
                Agency.WaitSignal(MCAgency.MC_Signal_e.MC_EXEC_AGENT);
                Agency.ResetSignal();
                try
                {
                    agent = Agency.FindAgentByName("mobagent1");
                    Console.WriteLine("Found agent\n" + agent.ToString() + ".");

                    temp = agent.TerminateAgent();
                    Console.WriteLine("TerminateAgent() returned " + 
                        temp.ToString() + ".");
                }
                catch (Exception e)
                {
                    Console.WriteLine("Exception: " + e.Message);
                }
            }
        }
    }
}
