/* mc_sample_app.c
 *
 * This sample program uses the Mobile C library to build
 * a simple command-line driven client/server app. 
 * 
 * 12/15/2006
 * */

#include <libmc.h>
#include <stdio.h>
int main(int argc, char *argv[])
{
    MCAgency_t agency;
    MCAgencyOptions_t options;
    int i;
    int port=5050;
    /* We want _all_ the threads on: including the command
     * prompt thread, which is off by default */
    MC_InitializeAgencyOptions(&options);
    for (i = 0; i < MC_THREAD_ALL; i++) {
        MC_SetThreadOn(&options, i);
    }
    if (argc == 2) {
        printf("Starting agency listening on port %d.\n",
                atoi(argv[1]) );
        agency = MC_Initialize(
                atoi(argv[1]),
                &options
                );
    } else {
        agency = MC_Initialize(
                port,
                &options);
    }

    if (argc == 4) {
 /* Note: The third argument of the following function may also be a
    valid IP address in the form of a string. i.e. 192.168.0.1 */
        MC_SendAgentMigrationMessageFile(
                agency,
                (char *)argv[1],
                (char *)argv[2],
                atoi((char *)argv[3]) );
    } else {
        printf("To send an xml file on startup, run:\n");
        printf("%s <xml file> <remote host> <remote port>\n", argv[0]);
        printf("\nStarting simple MobileC listen server...\n");
        /* Init the agency */

        MC_MainLoop(agency);
    }
    return 0;
}

