/************************************************************
* File: cs2ch.h 
* Header file for example package that shows how to interface
* Ch and C#.
************************************************************/
#ifndef CS2CH_H
#define CS2CH_H

#ifndef _CH_
#include <ch.h>
#endif

/* Null, just in case */
#ifndef NULL
#define NULL ((void*)0)
#endif

/* define boolean numbers */
#define TRUE 1
#define FALSE 0

/* Calling convention definition for different platforms */
#ifdef _CH_
#define STDCALL
#define EXPORTCH
#else
#define STDCALL __stdcall
#endif

/* Typedef for structs */
typedef struct struct1_s
{
	int i;
	double d;
	int iarr[8];
	int uses;
	char* name;
} struct1_t;

typedef struct struct2_s
{
	int i;
	double d;
	int iarr[8];
	struct struct1_s* s;
	int uses;
	char* name;
} struct2_t;

/* Typedef for callbacks */
typedef int (STDCALL *Fx)(char*);

/* Exported functions */
EXPORTCH int add(int a, int b);
EXPORTCH int func1(struct1_t s1, struct2_t s2);
EXPORTCH double func2(struct1_t *s1, struct2_t *s2);
EXPORTCH struct1_t* new_struct1(void);
EXPORTCH void free_struct1(struct1_t* s);
EXPORTCH void free_struct2(struct2_t* s);
EXPORTCH int setCallback(Fx f);
EXPORTCH int callFptr(char* s);
EXPORTCH int get_inc_int(void);

/* Load code from file cs2chfunc.c for Ch */
#ifdef _CH_
#pragma importf "cs2chfunc.c"
#endif

#endif /* CS2CH_H */
