using System;
using System.Collections.Generic;
using System.Text;
using LibMC;
using System.Threading;

/*
 * Steps for using LibMC:
 * 1. Create your desired type of project.
 * 2. Add a reference to the LibMC project.
 * 3. Add "using LibmC;" where necessary.
 * 4. For any XML files you want to use, 
 *    set "Copy to output directory" to "Copy Always" or "Copy if newer."
 * 5. Set working directory if desired.
 * 6. Enable unmanaged code debugging if desired.
 */

/** \file /LibMCFipaTest/Program.cs
 * Program for testing miscellaneous functions in LibMC.NET.
 */

/**
 * \brief      Namespace for the LibMCFipaTest FIPA ACL test program.
 * 
 * This program demonstrates how to start an agency, load agents, and 
 * communicate with agents via ACL messages.
 */
namespace LibMCFipaTest
{
    /**
     * \brief   Main program class to start the example.
     */
    class Program
    {
        public static MCAgency Agency = new MCAgency();
        public static int localport = 5050;
        public static String host = "localhost";

        static void Main(string[] args)
        {
            int temp;
            Console.WriteLine("Starting Mobile-C.\n");

            Agency.Port = localport;
            Agency.SetThreadOff(MCAgency.MC_ThreadIndex_e.MC_THREAD_CP);
            temp = Agency.Initialize();
            if (temp != 0)
                Console.WriteLine("Initialize: " + temp.ToString() + "\n");

            Agency.SendAgentMigrationMessageFile("xml/test1.xml", host, localport);
            Agency.SendAgentMigrationMessageFile("xml/test2.xml", host, localport);
            Console.WriteLine("Sleeping while the agents load.");
            Thread.Sleep(3000);

            Console.WriteLine("Press 'enter' to send " + 
                "an acl message to the agent.");
            Console.ReadLine();

            MCAclMessage tmp = new MCAclMessage();
            tmp.New();
            tmp.SetPerformative(MCAclMessage.MC_FipaPerformative_e.FIPA_INFORM);

            tmp.SetSender("agency", "http://" + host + ":" + 
                localport.ToString() + "/acc");
            tmp.AddReplyTo("mobagent2", "http://" + host + ":" + 
                localport.ToString() + "/acc");

            tmp.AddReceiver("mobagent1", "http://" + host + ":" + 
                localport.ToString() + "/acc");
            tmp.SetContent("This is content. Yay!");
            Agency.AclSend(tmp);
            tmp.Destroy();

            Thread.Sleep(1000);
            Console.WriteLine("Press 'enter' to exit when messaging is done.");
            Console.ReadLine();

            Agency.End();
        }
    }
}
