#include <libmc.h>
#include <embedch.h>
#include <stdio.h>

struct arg_struct{
    int a;
    int b;
}arg;

int main(int argc, char *argv[])
{
  MCAgency_t agency;
  MCAgent_t agent;
  ChInterp_t interp;
  int retval;
  MCAgencyOptions_t options;
  int port=5051;

  MC_InitializeAgencyOptions(&options);
  MC_SetThreadOff(&options, MC_THREAD_CP); /* Turn off command prompt */

  /* Init the agency */
  agency = MC_Initialize(
      port,
      &options);

  printf("Please press 'enter' once the sample agent has arrived.\n");
  getchar();
  agent = MC_FindAgentByName(agency, "mobagent1");
  if (agent == NULL) {
    printf("Could not find agent!\n");
    exit(0);
  }
  /* The following executution of code may be performed two different
ways: The first way, which is commented out in this example, 
involves retrieving the agent's interpreter with
MC_GetAgentExecEngine() and using the Embedded Ch api to call
the function. The second method involves using the Mobile-C
api to call the function. Both of these methods used here produce
identical results. */
  arg.a = 50;
  arg.b = 51;
  /*interp = MC_GetAgentExecEngine(agent);
    Ch_CallFuncByName(interp, "hello", &retval, arg); */
  MC_CallAgentFunc(
      agent,
      "hello",
      &retval,
      &arg);
  printf("Value of %d was returned.\n", retval);
  return 0;
}
