using System;
using System.Collections.Generic;
using System.Text;
using LibMC;
using System.Threading;

/** \file /LibMCConsole/Program.cs
 * Program for starting a Mobile-C agency from a console. Also
 * attempts to find "mobagent1" repeatedly and display its information.
 */

/**
 * \brief      Namespace for the LibMCConsole test program.
 * 
 * This program demonstrates how to start an agency, find an agent,
 * use the Mobile-C command line. Also demonstrates how to terminate
 * an agent.
 */
namespace LibMCConsole
{
    class Program
    {
        public static MCAgency Agency = new MCAgency();
        public static int localport = 5050;
        public static int remoteport = 5051;

        static void Main(string[] args)
        {
            int temp;
            MCAgent agent;

            Console.WriteLine("Starting Mobile-C on port " + 
                localport.ToString() + ".\n");

            Agency.Port = localport;
            temp = Agency.Initialize();
            if (temp != 0)
                Console.WriteLine("Initialize: " + temp.ToString() + "\n");

            while (true)
            {
                Thread.Sleep(5000);
                try
                {
                    agent = Agency.FindAgentByName("persistent1");
                    Console.WriteLine("Found agent\n" + agent.ToString() + ".");
                    temp = agent.CallAgentFunc("func", IntPtr.Zero, IntPtr.Zero);
                    Console.WriteLine("CallAgentFunc() returned " + 
                        temp.ToString() + ".");
                    temp = agent.TerminateAgent();
                    Console.WriteLine("TerminateAgent() returned " + 
                        temp.ToString() + ".");
                }
                catch (Exception e)
                {
                    Console.WriteLine("Exception: " + e.Message);
                }
            }
        }
    }
}
