/****************************************
 * ir_structs.h
 *
 * Author:  Stephen S. Nestinger
 * Created: Nov. 1 2007
 ****************************************/

#ifndef _IR_STRUCTS_H_
#define _IR_STRUCTS_H_

//******************************
//* Structures
//******************************

// status structure
  struct ir_create_status_s {
    char 
     mode,
     comm;
  };

// Sensor structures
struct ir_create_pack0_s {
  unsigned char 
    bwd,
    wall,
    cliff_l,
    cliff_fl,
    cliff_fr,
    cliff_r,
    vwall,
    over_cur,
    ir,
    buttons,
    charge_state,
    bat_temp;
  short 
    distance,
    angle,
    current;
  unsigned short   
    voltage,
    bat_charge,
    bat_cap; 
};

struct ir_create_pack1_s {
  unsigned char 
    bwd,
    wall,
    cliff_l,
    cliff_fl,
    cliff_fr,
    cliff_r,
    vwall,
    over_cur;
};

struct ir_create_pack2_s {
  unsigned char 
    ir,
    buttons;
  short 
    distance,
    angle;
};

struct ir_create_pack3_s {
  unsigned char 
    charge_state,
    bat_temp;
  short
    current;
  unsigned short   
    voltage,
    bat_charge,
    bat_cap; 

};

struct ir_create_pack4_s {
  unsigned char 
    cargo_dio,
    charge_srcs;
  unsigned short
    wall_sig,
    cliff_lt_sig,
    cliff_fl_sig,
    cliff_fr_sig,
    cliff_rt_sig,
    cargo_adc;
};

struct ir_create_pack5_s {
  unsigned char 
    oi_mode,
    song_num,
    song_playing,
    num_stream_pkts;
  short 
    req_vel,
    req_rad,
    req_rt_vel,
    req_lt_vel;
}; 

struct ir_create_pack6_s {
  unsigned char 
    bwd,
    wall,
    cliff_l,
    cliff_fl,
    cliff_fr,
    cliff_r,
    vwall,
    over_cur,
    ir,
    buttons,
    charge_state,
    bat_temp;
  short 
    distance,
    angle,
    current;
  unsigned short   
    voltage,
    bat_charge,
    bat_cap; 
  unsigned char 
    cargo_dio,
    charge_srcs;
  unsigned short
    wall_sig,
    cliff_lt_sig,
    cliff_fl_sig,
    cliff_fr_sig,
    cliff_rt_sig,
    cargo_adc;
  unsigned char 
    oi_mode,
    song_num,
    song_playing,
    num_stream_pkts;
  short 
    req_vel,
    req_rad,
    req_rt_vel,
    req_lt_vel;
}; 

int sensorArray[] = 
 {
   sizeof(struct ir_create_pack0_s),
   sizeof(struct ir_create_pack1_s),
   sizeof(struct ir_create_pack2_s),
   sizeof(struct ir_create_pack3_s),
   sizeof(struct ir_create_pack4_s),
   sizeof(struct ir_create_pack5_s),
   sizeof(struct ir_create_pack6_s),
   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
   1, 1, 2, 2, 1, 2, 2, 1, 2, 2, 
   2, 2, 2, 2, 2, 1, 2, 1, 1, 1, 
   1, 1, 2, 2, 2, 2, 1
 };

//******************************

#endif
