/****************************************
 * ir_enums.h
 *
 * Author:  Stephen S. Nestinger
 * Created: Nov. 1 2007
 ****************************************/

#ifndef _IR_ENUMS_H_
#define _IR_ENUMS_H_

//******************************
//* Enumerations
//*******************************


// Modes
enum IR_MODE_E {
  IR_PASSIVE = 128,
  IR_START  = 128,
  IR_SAFE = 131,
  IR_FULL = 132
};

// Comm Stat
enum IR_COMM_STATE_E {
   IR_COMM_STARTED,
   IR_COMM_END
};

// Demos
enum IR_DEMO_E {
  IR_DEMO_ABORT = -1,
  IR_DEMO_COVER = 0,
  IR_DEMO_COVER_AND_DOCK,
  IR_DEMO_SPOT_COVER,
  IR_DEMO_MOUSE,
  IR_DEMO_FIG_EIGHT,
  IR_DEMO_WIMP,
  IR_DEMO_HOME,
  IR_DEMO_TAG,
  IR_DEMO_PACHEBEL,
  IR_DEMO_BANJO
};

// LEDs
enum IR_LED_E {
  IR_LED_PLY = 2,
  IR_LED_ADV = 8
};

// Sensor Packets
enum IR_SONG_E {
  IR_STORE,
  IR_PLAY
};

// Sensor Packets
enum IR_SENSOR_E {
  IR_PACKET_0 = 0,
  IR_PACKET_1,
  IR_PACKET_2,
  IR_PACKET_3,
  IR_PACKET_4,
  IR_PACKET_5,
  IR_PACKET_6,
  IR_BUMPS_AND_WHEEL,
  IR_WALL,
  IR_CLIFF_LT,
  IR_CLIFF_FL,
  IR_CLIFF_FR,
  IR_CLIFF_RT,
  IR_VIRTUAL_WALL,
  IR_OVER_CURRENT,
  IR_IR = 17,
  IR_BUTTONS,
  IR_DISTANCE,
  IR_ANGLE,
  IR_CHARGING_STATUS,
  IR_VOLTAGE,
  IR_CURRENT,
  IR_BAT_TEMP,
  IR_BAT_CHARGE,
  IR_BAT_CAPACITY,
  IR_WALL_SIGNAL,
  IR_CLIFF_LT_SIGNAL,
  IR_CLIFF_FL_SIGNAL,
  IR_CLIFF_FR_SIGNAL,
  IR_CLIFF_RT_SIGNAL,
  IR_CARGO_DIO,
  IR_CARGO_ADC,
  IR_AVAIL_CHARGE_SOURCES,
  IR_OI_MODE,
  IR_SONG_NUMBER,
  IR_SONG_PLAYING,
  IR_NUM_STREAM_PACKETS,
  IR_REQUESTED_VEL,
  IR_REQUESTED_RAD,
  IR_REQUESTED_RT_VEL,
  IR_REQUESTED_LT_VEL,
  IR_UNUSED
};

//*******************************

#endif
