/****************************************
 * ir_create.h
 *
 * Author:  Stephen S. Nestinger
 * Created: Nov. 1 2007
 ****************************************/
#ifndef _IR_CREATE_H_
#define _IR_CREATE_H_

#ifdef _CH_
#  pragma package <chcreate>
#endif

#include "ir_enums.h"
#include "ir_structs.h"

// Global variables
ir_create_status_s g_status = {0,0};

//******************************
//* Function Prototypes
//*******************************

// Public Functions
  int ir_init(char *devStr, char *baudRate);
  int ir_close();
  int ir_sendChr(unsigned char cmd);
  int ir_sendStr(unsigned char *str, int len);
  int ir_demo(IR_DEMO_E demo);
  int ir_leds(int ledCtrl, unsigned char pwrClr, unsigned char pwrInt);
  int ir_setDebug(int state);
  int ir_setMode(IR_MODE_E mode);
  int ir_songStore(int bank, unsigned char* song, int length); 
  int ir_songPlay(int bank);
  int ir_sensors(IR_SENSOR_E packetID, void *sensorStruc);
  int ir_turnAng(short degrees, short ang_vel);
// ir_power()
// ir_get_sensor_data()
  int ir_drive(short velocity, short radius);
  int ir_directDrive(short velR, short velL);
  int ir_driveDist(short distance, short vel);
// ir_digital_out()
// ir_pwm()
// ir_low_side_drivers()
// ir_send_ir()
// ir_query_list()
// ir_stream()
// ir_script()
// ir_wait()

// Private Functions
//int ir_comm_send(char*);
//int ir_comm_recv();

//*******************************

#ifdef _CH_
#  pragma importf <ir_create.chf>
#endif

#endif
