#include <unistd.h>
#include "ir_create.h"

int main(void)
{             
  int i; 
  unsigned long usec = 500000;

  ir_init("/dev/ttyS2", "57600");

  // LEDs can only be changed in safe mode
  ir_setMode(IR_SAFE);

  printf("Blink PWR LED 5 times at 1 sec interval between green and red\n");
  for(i=0;i<5;i++)
  {
    ir_leds(0, 0, 255); 
    usleep(usec);
    ir_leds(0, 255, 255); 
    usleep(usec);
  }
  
  printf("Blink all LEDs 5 times at 1 sec\n"); 
  for(i=0;i<5;i++)
  {
    ir_leds(IR_LED_PLY | IR_LED_ADV, 0, 255); 
    usleep(usec);
    ir_leds(0, 0, 0); 
    usleep(usec);
  }

  ir_close();       
}                          
