#include <libmc.h>
#include <stdio.h>

int main(int argc, char *argv[]) {
    MCAgency_t agency;
    MCAgencyOptions_t options;
    int i;

    MC_SetThreadOn(&options, MC_THREAD_CP);

    if(argc == 2) {
        printf("Start agency listening on port %d.\n", atoi(argv[1]));
        agency = MC_Initialize(atoi(argv[1]), &options);
    }
    else {
        printf("Start agency listening on port 5050.\n");
        agency = MC_Initialize(5050, &options);
    }

    if(argc == 4) {
        MC_SendAgentMigrationMessageFile(agency, 
                                         (char *)argv[1],
                                         (char *)argv[2], 
                                         atoi((char *)argv[3]));
    } 
    else {
        printf("To send an xml file on startup, run:\n");
        printf("%s <xml file> <remote host> <remote port>\n", argv[0]);
    }

    if(MC_MainLoop(agency) != 0) {
        MC_End(agency);
    }

    return 0;
}
