/*********************************************** 
 * File: dataacq.cpp                           *
 * This program is used to send a mobile agent * 
 * to an agency running on a gumstix, retrieve * 
 * the data carried back by the mobile agent,  * 
 * and create a graph and text output          * 
 ***********************************************/ 
#include <libmc.h>
#include <stdio.h>
#include <stdlib.h>
#include <chplot.h>

using namespace std;

int main(int argc, char *argv[]) {
    MCAgency_t agency;
    MCAgent_t agent;
    int *extent;
    int dim;
    double *ret;
    double **data;
    double *x;
    int i, j, k, size;
    class CPlot plot;

    if(argc == 2) {
        printf("Starting agency listening on port %d.\n", atoi(argv[1]));
        agency = MC_Initialize(atoi(argv[1]), NULL);
    }
    else {
        agency = MC_Initialize(5130, NULL);
    }
    MC_SendAgentMigrationMessageFile(agency,
                                     "agent_dataacq.xml",
                                     "bird3.engr.ucdavis.edu",
                                     5050);
    while(1) {
        printf("Waiting for agent return...\n");
        MC_WaitSignal(agency, MC_RECV_RETURN);
        agent = MC_FindAgentByName(agency, "mobagent1");
        if(agent == NULL) {
            MC_ResetSignal(agency);
            continue;
        }
        if(MC_GetAgentType(agent) != MC_RETURN_AGENT) {
            MC_ResetSignal(agency);
            continue;
        }
        else {
            break;
        }
    }
    MC_GetAgentReturnData(agent, 0, (void**)&ret, &dim, &extent);
    MC_ResetSignal(agency);

    printf("dim is %d\n", dim);
    printf("Extents are: ");
    size = 1;
    for(i=0; i<dim; i++) {
        printf("%d ", extent[i]);
        size *= extent[i];
    }
    printf("\n");
    printf("%d Elements:\n", size);

    x = (double *)malloc(extent[1]*sizeof(double));
    data = (double **)malloc(extent[0]*sizeof(double *));
    for(i=0; i<extent[0]; i++) {
        data[i] = (double *)malloc(extent[1]*sizeof(double));
    }

    k = 0;
    for(i=0; i<extent[0]; i++) {
        if(i == 0) {
            printf("\nX axis:");
        }
        else if(i == 1) {
            printf("\nY axis:");
        }
        for(j=0; j<extent[1]; j++) {
            data[i][j] = ret[k];
            if(!(j % 13)) {
                printf("\n");
            }
            printf("%.2f ", data[i][j]);
            k++;
        }
        printf("\n");
    }

    for(i=0; i<extent[1]; i++) {
        x[i] = i+1;
    }

    plot.data2DCurve(x, data[0], extent[1]);
    plot.data2DCurve(x, data[1], extent[1]);
    plot.legend("X Axis", 0);
    plot.legend("Y Axis", 1);
    plot.label(PLOT_AXIS_X, "Sample");
    plot.label(PLOT_AXIS_Y, "Acceleration (m/s^2)");
    plot.plotting();

    free(x);
    for(i=0; i<extent[0]; i++) {
        free(data[i]);
    }
    free(data);

    return 0;
}
