#!/bin/ch

#include <cgi.h>
#include <chplot.h>
#include <i2c-io-api.h>

int main() {
    class CRequest Request;
    class CResponse Response;
    int samples, interval;
    int i2cDev, i;
    uint8_t  baseChannel = 64;

    i2cDev = I2C_IO_Init("/dev/i2c-0", "0x0b");
    samples  = atoi(Request.getForm("samples"));
    interval = atoi(Request.getForm("interval"));

    if(samples == 0) {
          printf("You must have at least one sample");
          return -1;
    }
    else {
        int channels[8] = {0};
        int j;
        char something[10];
        uint16_t data[8][samples];
        int x[samples];

        for(i=0;i<8;i++) {
          sprintf(something, "chan%d", i);
          if(Request.getForm(something)) 
            channels[i] = 1;
        }
        for(i = 0; i<samples; i++) {
            for(j=0; j<8; j++) 
               I2C_IO_GetADC(i2cDev, baseChannel+j, &data[j][i]);

            usleep(interval);
            x[i] = i * interval;
        }

       if(Request.getForm("plot")) {
            CPlot plot;
            Response.setContentType("image/png");
            Response.begin();
            for(j=0;j<8;j++) {
                if(channels[j]) 
                  plot.data2D(x, data[j]);
            }
            plot.outputType(PLOT_OUTPUTTYPE_STREAM, "png");
            plot.plotting();
            Response.end();
        }
        else {
            Response.setContentType("text/html");
            Response.begin();
            printf("<TABLE><BR><TR>");

            for(j=0; j<8;j++) {
              if(channels[j]){
                printf("<TD ALIGN=CENTER WIDTH=50>");
                printf("Chan %d<BR><HR></TD>", j);
              }
            }

            printf("</TR>");

            for(i = 0; i<samples; i++) {
              printf("<TR>");
                for(j=0;j<8;j++) {
                    if(channels[j]) {
                      printf("<TD ALIGN=RIGHT WIDTH=50>");
                      printf("%d</TD>", data[j][i]);
                    }
                }
              printf("</TR>");
            }
            printf("</TABLE>");
            Response.end();
        }
    }

  I2C_IO_CloseDev();    
  return 0;
}
