/* accel.c  */
#include "i2c-io-api.h"

#define MEANX 512.0
#define MEANY 509.0
#define DELTA 208.0 
#define ACCELG 9.8 
#define NUMPTS 30

int main() {
  char* i2cDevName = "/dev/i2c-0";
  char* gI2cAddr = "0x0b";
  int ret, count = 0, channel = 64;
  uint16_t adcVal = 0;
  double a[2][100];

  ret = I2C_IO_Init(i2cDevName, gI2cAddr);

  printf("Sample  X Axis (g)  Y Axis (g)\n");
  printf("------  ----------  ----------\n");
  for(count=0; count<NUMPTS; count++) {
      if(I2C_IO_GetADC(ret, channel, &adcVal)) {
          a[0][count] = ((adcVal-MEANX)/DELTA)*ACCELG;
      }
      if(I2C_IO_GetADC(ret, channel+1, &adcVal)) {
          a[1][count] = ((adcVal-MEANY)/DELTA)*ACCELG;
      }
      printf("%6d  %10.3f  %10.3f\n", count, a[0][count], a[1][count]);
  }

  I2C_IO_CloseDev();
  return 0;
}
