#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <libmc.h>

#define IMAX 100
#define JMAX 100

struct Matrix {
  double x[IMAX][JMAX], y[IMAX][JMAX];
  double t[IMAX][JMAX], tnew[IMAX][JMAX];
  double residual[IMAX][JMAX];
}matrix; 

int main() {
  int i, j, ii, jj, count=0;
  double maxres[100000];
  FILE *stream;
  char *file1="temp.txt", *file2="x.txt", *file3="y.txt", *file4="maxres.txt", *file5="z.txt";
  
  MCAgency_t agency;
  MCAgent_t agent;
  MCAgencyOptions_t options;
  int local_port = 5130, mutex_var, *agentID, numResult;
  char *funcname = "numerical_method", **agentName, **serviceName;

  /* Set all the threads on, except the 'command prompt thread' */

  MC_InitializeAgencyOptions(&options);
  for(i=0; i<MC_THREAD_ALL; i++) {
    MC_SetThreadOn(&options, i);
  }
  MC_SetThreadOff(&options, MC_THREAD_CP);
  agency = MC_Initialize(local_port, &options);
  mutex_var = MC_SyncInit(agency, 55);
 
  /* Set up x and y matrices */
  for(i=0; i<IMAX; i++) {
    for(j=0; j<JMAX; j++) {
      matrix.x[i][j] = cos(M_PI_2*(IMAX-i-1)/(IMAX-1));
      matrix.y[i][j] = cos(M_PI_2*(JMAX-j-1)/(JMAX-1));
    }
  }

  /* Initialize t matrix */
  for(i=0; i<IMAX; i++) {
    for(j=0; j<JMAX; j++) {
      if(matrix.x[i][j]==cos(M_PI_2) || matrix.x[i][j]==1.0) {
        matrix.t[i][j] = 3.0*matrix.y[i][j]+2.0;
      }
      else if(matrix.y[i][j] == cos(M_PI_2)) {
        matrix.t[i][j] = fabs(cos(M_PI*matrix.x[i][j]))+1.0;
      }
      else if(matrix.y[i][j] == 1.0) {
        matrix.t[i][j] = 5.0*(sin(M_PI*matrix.x[i][j])+1.0);
      }
      else {
        matrix.t[i][j] = 3.5;
      }
    }
  }

  /* Start the iterations */
  clock();
  do {

    MC_MutexLock(agency, mutex_var);
    MC_SearchForService(agency, funcname, &agentName, &serviceName, &agentID, &numResult); 
    while(numResult == 0) {
      MC_MutexUnlock(agency, mutex_var);
      MC_MutexLock(agency, mutex_var);
      MC_SearchForService(agency, funcname, &agentName, &serviceName, &agentID, &numResult);
    }
    agent = MC_FindAgentByID(agency, agentID[0]);
    MC_CallAgentFunc(agent, funcname, NULL, &matrix);
    MC_MutexUnlock(agency, mutex_var);
    MC_DestroyServiceSearchResult(agentName, serviceName, agentID, numResult);
    count++;
    for(i=1; i<(IMAX-1); i++) {
      for(j=1; j<(JMAX-1); j++) {
        matrix.t[i][j] = matrix.tnew[i][j];
      }
    }
    maxres[count-1] = matrix.residual[1][1];
    for(i=1; i<(IMAX-1); i++) {
      for(j=1; j<(JMAX-1); j++) {
        if(matrix.residual[i][j] > maxres[count-1]) {
          maxres[count-1] = matrix.residual[i][j];
          ii = i+1;
          jj = j+1;
        }
      }
    }
    printf("maxres: %.3e   count: %d\n", maxres[count-1], count);
  } while(maxres[count-1] >= 1.0e-3); 
  printf("\nIterations: %d\n", count);
  printf("\nCPU time: %.3f secconds\n", clock()/1000000.0);
  printf("\nMaximum residual: %.3e degree, at T(i,j)=T(%d,%d)\n\n", maxres[count-1], ii, jj);
    
  /* Write the final temperature data into a file */    
  stream = fopen(file1, "w");
  if(stream == NULL) {
    printf("Error: cannot open %s\n", file1);
    exit(-1);
  }
  for(i=0; i<IMAX; i++) {
    for(j=0; j<JMAX; j++) {
      fprintf(stream, "%8.4f", matrix.t[i][j]);
    }
    fprintf(stream, "\n");
  }
  fclose(stream);

  /* Write x coordinates into a file */
  stream = fopen(file2, "w");
  if(stream == NULL) {
    printf("Error: cannot open %s\n", file2);
    exit(-1);
  }
  for(i=0; i<IMAX; i++) {
    for(j=0; j<JMAX; j++) {
      fprintf(stream, "%8.4f", matrix.x[i][j]);
    }
    fprintf(stream, "\n");
  }
  fclose(stream);

  /* Write y coordinates into a file */
  stream = fopen(file3, "w");
  if(stream == NULL) {
    printf("Error: cannot open %s\n", file3);
    exit(-1);
  }
  for(i=0; i<IMAX; i++) {
    for(j=0; j<JMAX; j++) {
      fprintf(stream, "%8.4f", matrix.y[i][j]);
    }
    fprintf(stream, "\n");	
  }	
  fclose(stream);

  /* Write maximum residual of each interation into a file */
  stream = fopen(file4, "w");
  if(stream == NULL) {
    printf("Error: cannot open %s\n", file4);
    exit(-1);
  }
  for(i=0; i<count; i++) {
    fprintf(stream, "%.3e\n", maxres[i]);
  }	
  fclose(stream);
    
  /* Write zero into a file */    
  stream = fopen(file5, "w");
  if(stream == NULL) {
    printf("Error: cannot open %s\n", file5);
    exit(-1);
  }
  for(i=0; i<IMAX; i++) {
    for(j=0; j<JMAX; j++) {
      fprintf(stream, "%2d", 0);
    }
    fprintf(stream, "\n");
  }
  fclose(stream);

  return 0;
}
