#include <stdio.h>
#include <stdlib.h>
#include <chplot.h>

#define N 100

int main() {
  int i, j;
  double x[N][N], y[N][N], t[N][N];
  FILE *stream;
  CPlot plot;
  string_t title="Steady-State Temperature Distribution";
  string_t xlabel="X (m)";
  string_t ylabel="Y (m)";
  string_t zlabel="Temperature (C)";

  stream = fopen("x.txt", "r");
  for(i=0; i<N; i++) {
    for(j=0; j<N; j++) {
      fscanf(stream, "%lf", &(x[i][j]));
    }
  }
  fclose(stream);

  stream = fopen("y.txt", "r");
  for(i=0; i<N; i++) { 
    for(j=0; j<N; j++) { 
      fscanf(stream, "%lf", &(y[i][j]));
    }
  }
  fclose(stream);

  stream = fopen("temp.txt", "r");
  for(i=0; i<N; i++) { 
    for(j=0; j<N; j++) {
      fscanf(stream, "%lf", &(t[i][j]));
    }
  }
  fclose(stream);

  stream = fopen("output.txt", "w");
  for(i=0;i<N; i++) {
    for(j=0;j<N; j++) {
      fprintf(stream, "%f %f %f\n", x[i][j], y[i][j], t[i][j]);
    }
    fprintf(stream, "\n");
  }
  fclose(stream);

  plot.dimension(3);
  plot.dataFile("output.txt", "using 1:2:3 with lines palett");
  plot.title(title);
  plot.label(PLOT_AXIS_X, xlabel);
  plot.label(PLOT_AXIS_Y, ylabel);
  plot.label(PLOT_AXIS_Z, zlabel);
  plot.grid(PLOT_ON);
  plot.plotting();

  return 0;
}

