#include <stdio.h>
#include <unistd.h>
#include <libmc.h>

int main() {
  double temp = 55.55, *ptemp;
  int i, n = 50000, local_port = 5050, mutex_id;
  char *mobagentname = "mobileagent";
  MCAgency_t agency;
  MCAgent_t agent;
  ChInterp_t interp;

  agency = MC_Initialize(local_port, NULL);
  for(i=0; i<n; i++) {
    printf("i = %d\n", i);
    agent = MC_FindAgentByName(agency, "mobileagent");
    if(agent != NULL) {
      interp = MC_GetAgentExecEngine(agent);
      if(interp != NULL) {
        ptemp = Ch_SymbolAddrByName(interp, "temp");
        temp = *ptemp;
        MC_DeleteAgent(agent);
      }
    }
    printf("temp = %f\n", temp);
    sleep(1);
  }
  MC_End(agency);

  return 0;
}
