#include <stdio.h>
#include <unistd.h>
#include <libmc.h>

struct Matrix {
  double a[2][2], b[2][2];
}matrix;

int main() {
  int i, j, local_port = 5130, mutex_id = 55, *agentID, numResult;
  char *funcname = "matrix_operate", **agentName, **serviceName;
  double c[2][2];
  MCAgency_t agency;
  MCAgent_t agent;

  for(i=0; i<2; i++) {
    for(j=0; j<2; j++) {
      matrix.a[i][j] = 2*i+j+1;
      matrix.b[i][j] = 2*i+j+5;
    }
  }
  agency = MC_Initialize(local_port, NULL);
  MC_SyncInit(agency, mutex_id);
  while(1) {
    MC_MutexLock(agency, mutex_id);
    MC_SearchForService(agency, funcname, &agentName, &serviceName, &agentID, &numResult);
    while(numResult == 0) {
      /* If no agent is found to have provided the desired service, unlock the Mutex variable 
         to allow an agent to register the desired service with the DF before locking the same 
         Mutex variable again for the next search of the desired service. */
      MC_MutexUnlock(agency, mutex_id);
      MC_MutexLock(agency, mutex_id);
      MC_SearchForService(agency, funcname, &agentName, &serviceName, &agentID, &numResult);
    }
    agent = MC_FindAgentByID(agency, agentID[0]);
    MC_CallAgentFunc(agent, funcname, &(c[0][0]), &matrix);
    MC_MutexUnlock(agency, mutex_id);
    MC_DestroyServiceSearchResult(agentName, serviceName, agentID, numResult);
  
    /* Output array c containing the matrix computation result to the screen. */
    printf("\n");
    for(i=0; i<2; i++) {
      for(j=0; j<2; j++) {
        printf("%8.2f", c[i][j]);
      }
      printf("\n");
    }
    /* Wait for 1 second to make the screen output of array c for each iteration clearly 
       readable. */
    sleep(1);
  }
  MC_End(agency);
  return 0;
}
