/********************************************************
 The following two lines are example statements that 
 will be dynamically added to complete the program. 
 The program will then be used as an agent code to 
 compose a mobile agent that will be sent to a 
 corresponding agency.

 char s_n[]="performance_agent1";
 char s_a[]="http://bird2.engr.ucdavis.edu:5050/acc";
********************************************************/
#include <stdio.h>
#include <math.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <fipa_acl.h>

double nulltime, TimeArray[2], TLimit, T[3];
double sa, sa_2, one, scale;
struct rusage rusage;

int dtime(double p[]) {
  double q;

  q = p[1];
  getrusage(RUSAGE_SELF, &rusage);
  p[1] = (double)(rusage.ru_utime.tv_sec);
  p[1] = p[1] + (double)(rusage.ru_utime.tv_usec) * 1.0e-06;
  p[0] = p[1] - q;

  return 0;
}

int main() {
  register double s, u, v, w, x;
  register long i, m, n;
  long loops, NLimit;

  double performance_index;
  char performance_index_str[50];
  char aclreceiver_name[] = "regulating_agent4";
  char aclreceiver_address[] = "http://shrimp.engr.ucdavis.edu:5050/acc";
  fipa_acl_message_p acl;

  loops = 15625;
  T[0] = 1.0E+06/(double)loops;
  TLimit = 1.5;
  NLimit = 51200000;
  one = 1.0;
  scale = one;

  dtime(TimeArray);
  dtime(TimeArray);

  n = loops;
  sa = 0.0;
  while (sa < TLimit) {
    n = 2 * n;
    s = 0.0;
    w = one;
    sa_2 = 102.3321513995275;
    v = sa_2 / (double)n;

    dtime(TimeArray);
    for(i=1; i<=(n-1); i++) {
      x = (double)i * v;
      u = x * x;
      s = s - w / (x + w) - x / (u + w) - u / (x * u + w);
    }
    dtime(TimeArray);

    sa = TimeArray[0];
    if(n == NLimit) {
      break;
    }
  }

  scale = 1.0E+06 / (double)n;
  T[0]  = scale;

  dtime(TimeArray);
  for(i=1; i<=(n-1); i++) {
  }
  dtime(TimeArray);

  nulltime = T[0] * TimeArray[0];
  if(nulltime < 0.0) {
    nulltime = 0.0;
  }

  T[1] = T[0] * sa - nulltime;
  T[2] = T[1] / 12.0;
  performance_index = one / T[2];

  printf("\nPerformance Index obtained by '%s' : '%f'\n",
         s_n, performance_index);
  sprintf(performance_index_str, "%f", performance_index);
 
  acl = mc_AclNew();
  mc_AclSetPerformative(
    acl,
    FIPA_INFORM);
  mc_AclSetSender(
    acl,
    s_n,
    s_a);
  mc_AclAddReceiver(
    acl,
    aclreceiver_name,
    aclreceiver_address);
  mc_AclSetContent(
    acl,
    performance_index_str);
  mc_AclSend(acl);

  return 0;
}
